/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ComponentStyle;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.next.LinkedElementNext;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NServer {
    private final Map<Network, String> connections = new LinkedHashMap<Network, String>();
    private USymbol shape = USymbol.RECTANGLE;
    private final String name;
    private String description;
    private final NBar bar = new NBar();
    private boolean hasItsOwnColumn = true;

    public void doNotHaveItsOwnColumn() {
        this.hasItsOwnColumn = false;
    }

    public final boolean hasItsOwnColumn() {
        return this.hasItsOwnColumn;
    }

    public Network getMainNetworkNext() {
        return this.connections.keySet().iterator().next();
    }

    public String getAdress(Network network) {
        return this.connections.get(network);
    }

    protected final TextBlock toTextBlock(String s, ISkinSimple spriteContainer) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        s = s.replace(", ", "\\n");
        return Display.getWithNewlines(s).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, spriteContainer);
    }

    public LinkedElementNext asTextBlockNext(double topMargin, Map<Network, String> conns, List<Network> networks, ISkinSimple spriteContainer) {
        LinkedHashMap<Network, TextBlock> conns2 = new LinkedHashMap<Network, TextBlock>();
        for (Map.Entry<Network, String> ent : conns.entrySet()) {
            conns2.put(ent.getKey(), this.toTextBlock(ent.getValue(), spriteContainer));
        }
        SymbolContext symbolContext = new SymbolContext(ColorParam.activityBackground.getDefaultValue(), ColorParam.activityBorder.getDefaultValue()).withShadow(3.0);
        TextBlock desc = this.toTextBlock(this.getDescription(), spriteContainer);
        TextBlock box = this.getShape().asSmall(TextBlockUtils.empty(0.0, 0.0), desc, TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
        return new LinkedElementNext(topMargin, this, box, conns2, networks);
    }

    public void connect(Network network, Map<String, String> props) {
        String address = props.get("address");
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.connections.containsKey(network)) {
            return;
        }
        this.connections.put(network, address);
        if (this.bar.getStart() == null) {
            this.bar.addStage(network.getNstage());
        } else if (network.getUp() != null && this.getMainNetworkNext() != network) {
            this.bar.addStage(network.getUp());
        }
    }

    public final String toString() {
        return this.name;
    }

    public NServer(String name) {
        this.description = name;
        this.name = name;
    }

    public NServer(String name, Object ... unused) {
        this.description = name;
        this.name = name;
    }

    protected final FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getName() {
        return this.name;
    }

    public final void setShape(String shapeName) {
        USymbol shapeFromString = USymbol.fromString(shapeName, ActorStyle.STICKMAN, ComponentStyle.RECTANGLE, PackageStyle.RECTANGLE);
        if (shapeFromString != null) {
            this.shape = shapeFromString;
        }
    }

    public final USymbol getShape() {
        return this.shape;
    }

    public final NBar getBar() {
        return this.bar;
    }
}

