/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.core.Network;
import net.sourceforge.plantuml.nwdiag.core.NwGroup;
import net.sourceforge.plantuml.nwdiag.next.GridTextBlockDecoratedNext;
import net.sourceforge.plantuml.nwdiag.next.NBar;
import net.sourceforge.plantuml.nwdiag.next.NPlayField;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class NwDiagram
extends UmlDiagram {
    private boolean initDone;
    private final Map<String, NServer> servers = new LinkedHashMap<String, NServer>();
    private final List<Network> networks = new ArrayList<Network>();
    private final List<NwGroup> groups = new ArrayList<NwGroup>();
    private NwGroup currentGroup = null;
    private final NPlayField playField = new NPlayField();
    private final double margin = 5.0;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Nwdiag)");
    }

    public NwDiagram(UmlSource source) {
        super(source, UmlDiagramType.NWDIAG);
    }

    public void init() {
        this.initDone = true;
    }

    private Network currentNetwork() {
        if (this.networks.size() == 0) {
            return null;
        }
        return this.networks.get(this.networks.size() - 1);
    }

    public CommandExecutionResult openGroup(String name) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        this.currentGroup = new NwGroup(name, this.currentNetwork());
        this.groups.add(this.currentGroup);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult openNetwork(String name) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        this.createNetwork(name);
        return CommandExecutionResult.ok();
    }

    private Network createNetwork(String name) {
        Network network = new Network(this.playField.getLast(), this.playField.createNewStage(), name, this.networks.size());
        this.networks.add(network);
        return network;
    }

    public CommandExecutionResult link(String name1, String name2) {
        NServer element;
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.currentNetwork() == null) {
            this.createNetwork(name1);
            element = new NServer(name2, this.currentNetwork(), this.getSkinParam());
        } else {
            NServer already = this.servers.get(name1);
            Network network1 = this.createNetwork("");
            network1.goInvisible();
            if (already != null) {
                this.connect(already, this.toSet(null));
            }
            element = new NServer(name2, this.currentNetwork(), this.getSkinParam());
        }
        this.servers.put(name2, element);
        this.addInternal(element, this.toSet(null));
        return CommandExecutionResult.ok();
    }

    private void addInternal(NServer server, Map<String, String> props) {
        String shape;
        this.connect(server, props);
        String description = props.get("description");
        if (description != null) {
            server.setDescription(description);
        }
        if ((shape = props.get("shape")) != null) {
            server.setShape(shape);
        }
        this.playField.addInPlayfield(server.getBar());
    }

    private void connect(NServer server, Map<String, String> props) {
        server.connect(this.currentNetwork(), props);
    }

    public CommandExecutionResult addElement(String name, String definition) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if (this.currentGroup != null) {
            this.currentGroup.addName(name);
        }
        NServer server = null;
        if (this.currentNetwork() == null) {
            if (this.currentGroup != null) {
                return CommandExecutionResult.ok();
            }
            assert (this.currentGroup == null);
            Network network1 = this.createNetwork("");
            network1.goInvisible();
            server = new NServer(name, this.currentNetwork(), this.getSkinParam());
            this.servers.put(name, server);
            server.doNotHaveItsOwnColumn();
        } else {
            server = this.servers.get(name);
            if (server == null) {
                server = new NServer(name, this.currentNetwork(), this.getSkinParam());
                this.servers.put(name, server);
            }
        }
        this.addInternal(server, this.toSet(definition));
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult endSomething() {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        this.currentGroup = null;
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult errorNoInit() {
        return CommandExecutionResult.error("Maybe you forget 'nwdiag {' in your diagram ?");
    }

    private Map<String, String> toSet(String definition) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (definition == null) {
            return result;
        }
        Pattern p = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\"([^\"]*)\"|[^\\s,]+)");
        Matcher m = p.matcher(definition);
        while (m.find()) {
            String name = m.group(1);
            String value = m.group(3) == null ? m.group(2) : m.group(3);
            result.put(name, value);
        }
        return result;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextBlock()).write(os);
    }

    private TextBlockBackcolored getTextBlock() {
        return new TextBlockBackcolored(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return NwDiagram.this.getTotalDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HColor getBackcolor() {
                return null;
            }
        };
    }

    private TextBlock toTextBlock(String name, String s) {
        if (s != null) {
            name = name + "\\n" + s;
        }
        return Display.getWithNewlines(name).create(this.getFontConfiguration(), HorizontalAlignment.RIGHT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HColorUtils.BLACK, HColorUtils.BLACK, false);
    }

    private Dimension2D getTotalDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                NwDiagram.this.drawMe(ug);
            }
        }, stringBounder, true).getDimension();
    }

    private void drawMe(UGraphic ug) {
        ug = ug.apply(new UTranslate(5.0, 5.0));
        StringBounder stringBounder = ug.getStringBounder();
        double deltaX = 0.0;
        double deltaY = 0.0;
        GridTextBlockDecoratedNext grid = this.buildGrid(stringBounder);
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlock(current.getDisplayName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            if (i == 0) {
                deltaY = (dim.getHeight() - 5.0) / 2.0;
            }
            deltaX = Math.max(deltaX, dim.getWidth());
        }
        double y = 0.0;
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            String address = current.getOwnAdress();
            TextBlock desc = this.toTextBlock(current.getDisplayName(), address);
            Dimension2D dim = desc.calculateDimension(stringBounder);
            desc.drawU(ug.apply(new UTranslate(deltaX - dim.getWidth(), y)));
            y += grid.lineHeight(stringBounder, i);
        }
        grid.drawU(ug.apply(ColorParam.activityBorder.getDefaultValue()).apply(ColorParam.activityBackground.getDefaultValue().bg()).apply(new UTranslate(deltaX += 5.0, deltaY)));
        Dimension2D dimGrid = grid.calculateDimension(stringBounder);
        ug.apply(new UTranslate(dimGrid.getWidth() + deltaX + 5.0, dimGrid.getHeight() + deltaY + 5.0)).draw(new UEmpty(1.0, 1.0));
    }

    private Map<Network, String> getLinks(NServer element) {
        LinkedHashMap<Network, String> result = new LinkedHashMap<Network, String>();
        for (Network network : this.networks) {
            String s = element.getAdress(network);
            if (s == null) continue;
            result.put(network, s);
        }
        return result;
    }

    private GridTextBlockDecoratedNext buildGrid(StringBounder stringBounder) {
        this.playField.fixGroups(this.groups, this.servers.values());
        GridTextBlockDecoratedNext grid = new GridTextBlockDecoratedNext(this.networks.size(), this.servers.size(), this.groups, this.networks, this.getSkinParam());
        Map<NBar, Integer> layout = this.playField.doLayout();
        for (int i = 0; i < this.networks.size(); ++i) {
            Network current = this.networks.get(i);
            for (Map.Entry<String, NServer> ent : this.servers.entrySet()) {
                NServer server = ent.getValue();
                if (server.getMainNetworkNext() != current) continue;
                Map<Network, String> conns = this.getLinks(server);
                int col = layout.get(server.getBar());
                double topMargin = 15.0;
                NwGroup group = this.getGroupOf(server);
                if (group != null) {
                    topMargin += group.getTopHeaderHeight(stringBounder, this.getSkinParam());
                }
                grid.add(i, col, server.asTextBlockNext(topMargin, conns, this.networks, this.getSkinParam()));
            }
        }
        return grid;
    }

    private NwGroup getGroupOf(NServer server) {
        for (NwGroup group : this.groups) {
            if (!group.containsNext(server)) continue;
            return group;
        }
        return null;
    }

    public CommandExecutionResult setProperty(String property, String value) {
        if (!this.initDone) {
            return this.errorNoInit();
        }
        if ("address".equalsIgnoreCase(property) && this.currentNetwork() != null) {
            this.currentNetwork().setOwnAdress(value);
        }
        if ("width".equalsIgnoreCase(property) && this.currentNetwork() != null) {
            this.currentNetwork().setFullWidth("full".equalsIgnoreCase(value));
        }
        if ("color".equalsIgnoreCase(property)) {
            HColor color;
            HColor hColor = color = value == null ? null : NwGroup.colors.getColorOrWhite(this.getSkinParam().getThemeStyle(), value);
            if (this.currentGroup != null) {
                this.currentGroup.setColor(color);
            } else if (this.currentNetwork() != null) {
                this.currentNetwork().setColor(color);
            }
        }
        if ("description".equalsIgnoreCase(property)) {
            if (this.currentGroup == null) {
                this.currentNetwork().setDescription(value);
            } else {
                this.currentGroup.setDescription(value);
            }
        }
        return CommandExecutionResult.ok();
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.none();
    }
}

