from typing import Union
from ssdeep._libfuzzy import ffi as ffi, lib as lib

Buffer = Union[bytes, str]

class BaseError(Exception): ...
class InternalError(BaseError): ...

class BaseHash:
    @property
    def block_size(self): ...
    @property
    def name(self): ...
    def digest(self, elimseq: bool = ..., notrunc: bool = ...) -> None: ...

class Hash(BaseHash):
    def __init__(self) -> None: ...
    def copy(self): ...
    def update(self, buf: Buffer, encoding: str = ...) -> None: ...
    def digest(self, elimseq: bool = ..., notrunc: bool = ...): ...
    def __del__(self) -> None: ...

class PseudoHash(BaseHash):
    def __init__(self) -> None: ...
    def copy(self): ...
    def update(self, buf: Buffer, encoding: str = ...) -> None: ...
    def digest(self, elimseq: bool = ..., notrunc: bool = ...): ...

def compare(sig1: str, sig2: str) -> int: ...
def hash(buf: Buffer, encoding: str = ...) -> str: ...
def hash_from_file(filename: str) -> str: ...
