import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UscSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Use this option if the universal secrets value is a base64 encoded binary. (relevant for aws/azure/gcp/k8s targets)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#binary_value UscSecret#binary_value}
    */
    readonly binaryValue?: boolean | cdktf.IResolvable;
    /**
    * Description of the universal secret (relevant for aws/hashi target)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#description UscSecret#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#id UscSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The namespace (relevant for Hashi vault target)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#namespace UscSecret#namespace}
    */
    readonly namespace?: string;
    /**
    * Either secret or certificate (Relevant only for Azure KV targets)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#object_type UscSecret#object_type}
    */
    readonly objectType?: string;
    /**
    * Name for the new universal secrets
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#secret_name UscSecret#secret_name}
    */
    readonly secretName: string;
    /**
    * Tags for the universal secrets
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#tags UscSecret#tags}
    */
    readonly tags?: string[];
    /**
    * Name of the Universal Secrets Connector item
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#usc_name UscSecret#usc_name}
    */
    readonly uscName: string;
    /**
    * Value of the universal secrets item, either text or base64 encoded binary
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#value UscSecret#value}
    */
    readonly value?: string;
    /**
    * Version ID of the secret (if not specified, will retrieve the last version)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#version_id UscSecret#version_id}
    */
    readonly versionId?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret akeyless_usc_secret}
*/
export declare class UscSecret extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_usc_secret";
    /**
    * Generates CDKTF code for importing a UscSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the UscSecret to import
    * @param importFromId The id of the existing UscSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the UscSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/usc_secret akeyless_usc_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UscSecretConfig
    */
    constructor(scope: Construct, id: string, config: UscSecretConfig);
    private _binaryValue?;
    get binaryValue(): boolean | cdktf.IResolvable;
    set binaryValue(value: boolean | cdktf.IResolvable);
    resetBinaryValue(): void;
    get binaryValueInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
    get secretId(): string;
    private _secretName?;
    get secretName(): string;
    set secretName(value: string);
    get secretNameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _uscName?;
    get uscName(): string;
    set uscName(value: string);
    get uscNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    private _versionId?;
    get versionId(): string;
    set versionId(value: string);
    resetVersionId(): void;
    get versionIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
