import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetWindowsConfig extends cdktf.TerraformMetaArguments {
    /**
    * SSL CA certificate in base64 encoding generated from a trusted Certificate Authority (CA)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#certificate TargetWindows#certificate}
    */
    readonly certificate?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#description TargetWindows#description}
    */
    readonly description?: string;
    /**
    * User domain name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#domain TargetWindows#domain}
    */
    readonly domain?: string;
    /**
    * server hostname or IP Address
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#hostname TargetWindows#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#id TargetWindows#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key is used to encrypt the target secret value. If the key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#key TargetWindows#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#name TargetWindows#name}
    */
    readonly name: string;
    /**
    * Privileged user password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#password TargetWindows#password}
    */
    readonly password: string;
    /**
    * Server WinRM port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#port TargetWindows#port}
    */
    readonly port?: string;
    /**
    * Enable/Disable TLS for WinRM over HTTPS [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#use_tls TargetWindows#use_tls}
    */
    readonly useTls?: string;
    /**
    * Privileged username
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#username TargetWindows#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows akeyless_target_windows}
*/
export declare class TargetWindows extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_windows";
    /**
    * Generates CDKTF code for importing a TargetWindows resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetWindows to import
    * @param importFromId The id of the existing TargetWindows that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetWindows to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_windows akeyless_target_windows} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetWindowsConfig
    */
    constructor(scope: Construct, id: string, config: TargetWindowsConfig);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _useTls?;
    get useTls(): string;
    set useTls(value: string);
    resetUseTls(): void;
    get useTlsInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
