import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetLinkedConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#description TargetLinked#description}
    */
    readonly description?: string;
    /**
    * A comma seperated list of server hosts and server descriptions joined by semicolon ';' (i.e. 'server-dev.com;My Dev server,server-prod.com;My Prod server description')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#hosts TargetLinked#hosts}
    */
    readonly hosts?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#id TargetLinked#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Linked Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#name TargetLinked#name}
    */
    readonly name: string;
    /**
    * The parent Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#parent_target_name TargetLinked#parent_target_name}
    */
    readonly parentTargetName?: string;
    /**
    * Specifies the hosts type, relevant only when working without parent target
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#type TargetLinked#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked akeyless_target_linked}
*/
export declare class TargetLinked extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_linked";
    /**
    * Generates CDKTF code for importing a TargetLinked resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetLinked to import
    * @param importFromId The id of the existing TargetLinked that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetLinked to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_linked akeyless_target_linked} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetLinkedConfig
    */
    constructor(scope: Construct, id: string, config: TargetLinkedConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hosts?;
    get hosts(): string;
    set hosts(value: string);
    resetHosts(): void;
    get hostsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parentTargetName?;
    get parentTargetName(): string;
    set parentTargetName(value: string);
    resetParentTargetName(): void;
    get parentTargetNameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
