import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetK8SConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#description TargetK8S#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#id TargetK8S#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * K8S Cluster certificate. Base 64 encoded certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#k8s_cluster_ca_cert TargetK8S#k8s_cluster_ca_cert}
    */
    readonly k8SClusterCaCert: string;
    /**
    * K8S Cluster endpoint. https:// , <DNS / IP> of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#k8s_cluster_endpoint TargetK8S#k8s_cluster_endpoint}
    */
    readonly k8SClusterEndpoint: string;
    /**
    * K8S Cluster authentication token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#k8s_cluster_token TargetK8S#k8s_cluster_token}
    */
    readonly k8SClusterToken: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#key TargetK8S#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#name TargetK8S#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s akeyless_target_k8s}
*/
export declare class TargetK8S extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_k8s";
    /**
    * Generates CDKTF code for importing a TargetK8S resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetK8S to import
    * @param importFromId The id of the existing TargetK8S that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetK8S to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_k8s akeyless_target_k8s} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetK8SConfig
    */
    constructor(scope: Construct, id: string, config: TargetK8SConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _k8SClusterCaCert?;
    get k8SClusterCaCert(): string;
    set k8SClusterCaCert(value: string);
    get k8SClusterCaCertInput(): string | undefined;
    private _k8SClusterEndpoint?;
    get k8SClusterEndpoint(): string;
    set k8SClusterEndpoint(value: string);
    get k8SClusterEndpointInput(): string | undefined;
    private _k8SClusterToken?;
    get k8SClusterToken(): string;
    set k8SClusterToken(value: string);
    get k8SClusterTokenInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
