import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetGlobalsignConfig extends cdktf.TerraformMetaArguments {
    /**
    * Email of the GlobalSign GCC account contact
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#contact_email TargetGlobalsign#contact_email}
    */
    readonly contactEmail: string;
    /**
    * First name of the GlobalSign GCC account contact
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#contact_first_name TargetGlobalsign#contact_first_name}
    */
    readonly contactFirstName: string;
    /**
    * Last name of the GlobalSign GCC account contact
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#contact_last_name TargetGlobalsign#contact_last_name}
    */
    readonly contactLastName: string;
    /**
    * Telephone of the GlobalSign GCC account contact
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#contact_phone TargetGlobalsign#contact_phone}
    */
    readonly contactPhone: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#description TargetGlobalsign#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#id TargetGlobalsign#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#key TargetGlobalsign#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#name TargetGlobalsign#name}
    */
    readonly name: string;
    /**
    * Password of the GlobalSign GCC account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#password TargetGlobalsign#password}
    */
    readonly password: string;
    /**
    * Profile ID of the GlobalSign GCC account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#profile_id TargetGlobalsign#profile_id}
    */
    readonly profileId: string;
    /**
    * Timeout waiting for certificate validation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#timeout TargetGlobalsign#timeout}
    */
    readonly timeout?: string;
    /**
    * Username of the GlobalSign GCC account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#username TargetGlobalsign#username}
    */
    readonly username: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign akeyless_target_globalsign}
*/
export declare class TargetGlobalsign extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_globalsign";
    /**
    * Generates CDKTF code for importing a TargetGlobalsign resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetGlobalsign to import
    * @param importFromId The id of the existing TargetGlobalsign that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetGlobalsign to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_globalsign akeyless_target_globalsign} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetGlobalsignConfig
    */
    constructor(scope: Construct, id: string, config: TargetGlobalsignConfig);
    private _contactEmail?;
    get contactEmail(): string;
    set contactEmail(value: string);
    get contactEmailInput(): string | undefined;
    private _contactFirstName?;
    get contactFirstName(): string;
    set contactFirstName(value: string);
    get contactFirstNameInput(): string | undefined;
    private _contactLastName?;
    get contactLastName(): string;
    set contactLastName(value: string);
    get contactLastNameInput(): string | undefined;
    private _contactPhone?;
    get contactPhone(): string;
    set contactPhone(value: string);
    get contactPhoneInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _profileId?;
    get profileId(): string;
    set profileId(value: string);
    get profileIdInput(): string | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    resetTimeout(): void;
    get timeoutInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
