import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetGitlabConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#description TargetGitlab#description}
    */
    readonly description?: string;
    /**
    * Gitlab access token
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#gitlab_access_token TargetGitlab#gitlab_access_token}
    */
    readonly gitlabAccessToken?: string;
    /**
    * Gitlab tls certificate (base64 encoded)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#gitlab_certificate TargetGitlab#gitlab_certificate}
    */
    readonly gitlabCertificate?: string;
    /**
    * Gitlab base url
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#gitlab_url TargetGitlab#gitlab_url}
    */
    readonly gitlabUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#id TargetGitlab#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#key TargetGitlab#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#name TargetGitlab#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab akeyless_target_gitlab}
*/
export declare class TargetGitlab extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_gitlab";
    /**
    * Generates CDKTF code for importing a TargetGitlab resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetGitlab to import
    * @param importFromId The id of the existing TargetGitlab that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetGitlab to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gitlab akeyless_target_gitlab} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetGitlabConfig
    */
    constructor(scope: Construct, id: string, config: TargetGitlabConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gitlabAccessToken?;
    get gitlabAccessToken(): string;
    set gitlabAccessToken(value: string);
    resetGitlabAccessToken(): void;
    get gitlabAccessTokenInput(): string | undefined;
    private _gitlabCertificate?;
    get gitlabCertificate(): string;
    set gitlabCertificate(value: string);
    resetGitlabCertificate(): void;
    get gitlabCertificateInput(): string | undefined;
    private _gitlabUrl?;
    get gitlabUrl(): string;
    set gitlabUrl(value: string);
    resetGitlabUrl(): void;
    get gitlabUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
