import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetGithubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#description TargetGithub#description}
    */
    readonly description?: string;
    /**
    * Github application id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#github_app_id TargetGithub#github_app_id}
    */
    readonly githubAppId?: number;
    /**
    * Github application private key (base64 encoded key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#github_app_private_key TargetGithub#github_app_private_key}
    */
    readonly githubAppPrivateKey?: string;
    /**
    * Github base url
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#github_base_url TargetGithub#github_base_url}
    */
    readonly githubBaseUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#id TargetGithub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#key TargetGithub#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#name TargetGithub#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github akeyless_target_github}
*/
export declare class TargetGithub extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_github";
    /**
    * Generates CDKTF code for importing a TargetGithub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetGithub to import
    * @param importFromId The id of the existing TargetGithub that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetGithub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_github akeyless_target_github} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetGithubConfig
    */
    constructor(scope: Construct, id: string, config: TargetGithubConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _githubAppId?;
    get githubAppId(): number;
    set githubAppId(value: number);
    resetGithubAppId(): void;
    get githubAppIdInput(): number | undefined;
    private _githubAppPrivateKey?;
    get githubAppPrivateKey(): string;
    set githubAppPrivateKey(value: string);
    resetGithubAppPrivateKey(): void;
    get githubAppPrivateKeyInput(): string | undefined;
    private _githubBaseUrl?;
    get githubBaseUrl(): string;
    set githubBaseUrl(value: string);
    resetGithubBaseUrl(): void;
    get githubBaseUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
