import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetGcpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#description TargetGcp#description}
    */
    readonly description?: string;
    /**
    * Base64-encoded service account private key text
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#gcp_key TargetGcp#gcp_key}
    */
    readonly gcpKey?: string;
    /**
    * GCP service account email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#gcp_sa_email TargetGcp#gcp_sa_email}
    */
    readonly gcpSaEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#id TargetGcp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#key TargetGcp#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#name TargetGcp#name}
    */
    readonly name: string;
    /**
    * Use the GW's Cloud IAM
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#use_gw_cloud_identity TargetGcp#use_gw_cloud_identity}
    */
    readonly useGwCloudIdentity?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp akeyless_target_gcp}
*/
export declare class TargetGcp extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_gcp";
    /**
    * Generates CDKTF code for importing a TargetGcp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetGcp to import
    * @param importFromId The id of the existing TargetGcp that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetGcp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_gcp akeyless_target_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetGcpConfig
    */
    constructor(scope: Construct, id: string, config: TargetGcpConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _gcpKey?;
    get gcpKey(): string;
    set gcpKey(value: string);
    resetGcpKey(): void;
    get gcpKeyInput(): string | undefined;
    private _gcpSaEmail?;
    get gcpSaEmail(): string;
    set gcpSaEmail(value: string);
    resetGcpSaEmail(): void;
    get gcpSaEmailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _useGwCloudIdentity?;
    get useGwCloudIdentity(): boolean | cdktf.IResolvable;
    set useGwCloudIdentity(value: boolean | cdktf.IResolvable);
    resetUseGwCloudIdentity(): void;
    get useGwCloudIdentityInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
