import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetDbConfig extends cdktf.TerraformMetaArguments {
    /**
    * Database name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#db_name TargetDb#db_name}
    */
    readonly dbName?: string;
    /**
    * Set of root certificate authorities in base64 encoding used by clients to verify server certificates
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#db_server_certificates TargetDb#db_server_certificates}
    */
    readonly dbServerCertificates?: string;
    /**
    * Server name is used to verify the hostname on the returned certificates unless InsecureSkipVerify is provided. It is also included in the client's handshake to support virtual hosting unless it is an IP address
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#db_server_name TargetDb#db_server_name}
    */
    readonly dbServerName?: string;
    /**
    * Database type: mysql/mssql/postgres/mongodb/snowflake/oracle/cassandra/redshift
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#db_type TargetDb#db_type}
    */
    readonly dbType: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#description TargetDb#description}
    */
    readonly description?: string;
    /**
    * Database host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#host TargetDb#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#id TargetDb#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#key TargetDb#key}
    */
    readonly key?: string;
    /**
    * Flag, set database type to mongodb and the flag to true to create Mongo Atlas target
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#mongodb_atlas TargetDb#mongodb_atlas}
    */
    readonly mongodbAtlas?: boolean | cdktf.IResolvable;
    /**
    * MongoDB Atlas private key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#mongodb_atlas_api_private_key TargetDb#mongodb_atlas_api_private_key}
    */
    readonly mongodbAtlasApiPrivateKey?: string;
    /**
    * MongoDB Atlas public key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#mongodb_atlas_api_public_key TargetDb#mongodb_atlas_api_public_key}
    */
    readonly mongodbAtlasApiPublicKey?: string;
    /**
    * MongoDB Atlas project ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#mongodb_atlas_project_id TargetDb#mongodb_atlas_project_id}
    */
    readonly mongodbAtlasProjectId?: string;
    /**
    * MongoDB server default authentication database
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#mongodb_default_auth_db TargetDb#mongodb_default_auth_db}
    */
    readonly mongodbDefaultAuthDb?: string;
    /**
    * MongoDB server URI options (e.g. replicaSet=mySet&authSource=authDB)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#mongodb_uri_options TargetDb#mongodb_uri_options}
    */
    readonly mongodbUriOptions?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#name TargetDb#name}
    */
    readonly name: string;
    /**
    * oracle db service name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#oracle_service_name TargetDb#oracle_service_name}
    */
    readonly oracleServiceName?: string;
    /**
    * Database port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#port TargetDb#port}
    */
    readonly port?: string;
    /**
    * Database password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#pwd TargetDb#pwd}
    */
    readonly pwd?: string;
    /**
    * Snowflake account name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#snowflake_account TargetDb#snowflake_account}
    */
    readonly snowflakeAccount?: string;
    /**
    * Enable/Disable SSL [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#ssl TargetDb#ssl}
    */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
    * SSL CA certificate in base64 encoding generated from a trusted Certificate Authority (CA)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#ssl_certificate TargetDb#ssl_certificate}
    */
    readonly sslCertificate?: string;
    /**
    * Database user name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#user_name TargetDb#user_name}
    */
    readonly userName?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db akeyless_target_db}
*/
export declare class TargetDb extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_db";
    /**
    * Generates CDKTF code for importing a TargetDb resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetDb to import
    * @param importFromId The id of the existing TargetDb that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetDb to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_db akeyless_target_db} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetDbConfig
    */
    constructor(scope: Construct, id: string, config: TargetDbConfig);
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    resetDbName(): void;
    get dbNameInput(): string | undefined;
    private _dbServerCertificates?;
    get dbServerCertificates(): string;
    set dbServerCertificates(value: string);
    resetDbServerCertificates(): void;
    get dbServerCertificatesInput(): string | undefined;
    private _dbServerName?;
    get dbServerName(): string;
    set dbServerName(value: string);
    resetDbServerName(): void;
    get dbServerNameInput(): string | undefined;
    private _dbType?;
    get dbType(): string;
    set dbType(value: string);
    get dbTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _mongodbAtlas?;
    get mongodbAtlas(): boolean | cdktf.IResolvable;
    set mongodbAtlas(value: boolean | cdktf.IResolvable);
    resetMongodbAtlas(): void;
    get mongodbAtlasInput(): boolean | cdktf.IResolvable | undefined;
    private _mongodbAtlasApiPrivateKey?;
    get mongodbAtlasApiPrivateKey(): string;
    set mongodbAtlasApiPrivateKey(value: string);
    resetMongodbAtlasApiPrivateKey(): void;
    get mongodbAtlasApiPrivateKeyInput(): string | undefined;
    private _mongodbAtlasApiPublicKey?;
    get mongodbAtlasApiPublicKey(): string;
    set mongodbAtlasApiPublicKey(value: string);
    resetMongodbAtlasApiPublicKey(): void;
    get mongodbAtlasApiPublicKeyInput(): string | undefined;
    private _mongodbAtlasProjectId?;
    get mongodbAtlasProjectId(): string;
    set mongodbAtlasProjectId(value: string);
    resetMongodbAtlasProjectId(): void;
    get mongodbAtlasProjectIdInput(): string | undefined;
    private _mongodbDefaultAuthDb?;
    get mongodbDefaultAuthDb(): string;
    set mongodbDefaultAuthDb(value: string);
    resetMongodbDefaultAuthDb(): void;
    get mongodbDefaultAuthDbInput(): string | undefined;
    private _mongodbUriOptions?;
    get mongodbUriOptions(): string;
    set mongodbUriOptions(value: string);
    resetMongodbUriOptions(): void;
    get mongodbUriOptionsInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oracleServiceName?;
    get oracleServiceName(): string;
    set oracleServiceName(value: string);
    resetOracleServiceName(): void;
    get oracleServiceNameInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    resetPort(): void;
    get portInput(): string | undefined;
    private _pwd?;
    get pwd(): string;
    set pwd(value: string);
    resetPwd(): void;
    get pwdInput(): string | undefined;
    private _snowflakeAccount?;
    get snowflakeAccount(): string;
    set snowflakeAccount(value: string);
    resetSnowflakeAccount(): void;
    get snowflakeAccountInput(): string | undefined;
    private _ssl?;
    get ssl(): boolean | cdktf.IResolvable;
    set ssl(value: boolean | cdktf.IResolvable);
    resetSsl(): void;
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    private _sslCertificate?;
    get sslCertificate(): string;
    set sslCertificate(value: string);
    resetSslCertificate(): void;
    get sslCertificateInput(): string | undefined;
    private _userName?;
    get userName(): string;
    set userName(value: string);
    resetUserName(): void;
    get userNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
