import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TargetAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS secret access key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#access_key TargetAws#access_key}
    */
    readonly accessKey?: string;
    /**
    * AWS access key ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#access_key_id TargetAws#access_key_id}
    */
    readonly accessKeyId: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#description TargetAws#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#id TargetAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Key name. The key will be used to encrypt the target secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#key TargetAws#key}
    */
    readonly key?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#name TargetAws#name}
    */
    readonly name: string;
    /**
    * AWS region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#region TargetAws#region}
    */
    readonly region?: string;
    /**
    * Required only for temporary security credentials retrieved using STS
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#session_token TargetAws#session_token}
    */
    readonly sessionToken?: string;
    /**
    * Use the GW's Cloud IAM
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#use_gw_cloud_identity TargetAws#use_gw_cloud_identity}
    */
    readonly useGwCloudIdentity?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws akeyless_target_aws}
*/
export declare class TargetAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_target_aws";
    /**
    * Generates CDKTF code for importing a TargetAws resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TargetAws to import
    * @param importFromId The id of the existing TargetAws that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TargetAws to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/target_aws akeyless_target_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TargetAwsConfig
    */
    constructor(scope: Construct, id: string, config: TargetAwsConfig);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    get accessKeyIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sessionToken?;
    get sessionToken(): string;
    set sessionToken(value: string);
    resetSessionToken(): void;
    get sessionTokenInput(): string | undefined;
    private _useGwCloudIdentity?;
    get useGwCloudIdentity(): boolean | cdktf.IResolvable;
    set useGwCloudIdentity(value: boolean | cdktf.IResolvable);
    resetUseGwCloudIdentity(): void;
    get useGwCloudIdentityInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
