"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret akeyless_static_secret}
*/
class StaticSecret extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a StaticSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StaticSecret to import
    * @param importFromId The id of the existing StaticSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StaticSecret to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "akeyless_static_secret", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/static_secret akeyless_static_secret} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StaticSecretConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'akeyless_static_secret',
            terraformGeneratorMetadata: {
                providerName: 'akeyless',
                providerVersion: '1.11.2',
                providerVersionConstraint: '~> 1.11.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._customField = config.customField;
        this._deleteProtection = config.deleteProtection;
        this._description = config.description;
        this._format = config.format;
        this._id = config.id;
        this._ignoreCache = config.ignoreCache;
        this._injectUrl = config.injectUrl;
        this._keepPrevVersion = config.keepPrevVersion;
        this._multilineValue = config.multilineValue;
        this._password = config.password;
        this._path = config.path;
        this._protectionKey = config.protectionKey;
        this._secureAccessBastionIssuer = config.secureAccessBastionIssuer;
        this._secureAccessEnable = config.secureAccessEnable;
        this._secureAccessHost = config.secureAccessHost;
        this._secureAccessSshCreds = config.secureAccessSshCreds;
        this._secureAccessSshUser = config.secureAccessSshUser;
        this._secureAccessUrl = config.secureAccessUrl;
        this._secureAccessWeb = config.secureAccessWeb;
        this._secureAccessWebBrowsing = config.secureAccessWebBrowsing;
        this._tags = config.tags;
        this._type = config.type;
        this._username = config.username;
        this._value = config.value;
    }
    get customField() {
        return this.getStringMapAttribute('custom_field');
    }
    set customField(value) {
        this._customField = value;
    }
    resetCustomField() {
        this._customField = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customFieldInput() {
        return this._customField;
    }
    get deleteProtection() {
        return this.getStringAttribute('delete_protection');
    }
    set deleteProtection(value) {
        this._deleteProtection = value;
    }
    resetDeleteProtection() {
        this._deleteProtection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteProtectionInput() {
        return this._deleteProtection;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get format() {
        return this.getStringAttribute('format');
    }
    set format(value) {
        this._format = value;
    }
    resetFormat() {
        this._format = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get formatInput() {
        return this._format;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get ignoreCache() {
        return this.getStringAttribute('ignore_cache');
    }
    set ignoreCache(value) {
        this._ignoreCache = value;
    }
    resetIgnoreCache() {
        this._ignoreCache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreCacheInput() {
        return this._ignoreCache;
    }
    get injectUrl() {
        return cdktf.Fn.tolist(this.getListAttribute('inject_url'));
    }
    set injectUrl(value) {
        this._injectUrl = value;
    }
    resetInjectUrl() {
        this._injectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get injectUrlInput() {
        return this._injectUrl;
    }
    get keepPrevVersion() {
        return this.getStringAttribute('keep_prev_version');
    }
    set keepPrevVersion(value) {
        this._keepPrevVersion = value;
    }
    resetKeepPrevVersion() {
        this._keepPrevVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepPrevVersionInput() {
        return this._keepPrevVersion;
    }
    get multilineValue() {
        return this.getBooleanAttribute('multiline_value');
    }
    set multilineValue(value) {
        this._multilineValue = value;
    }
    resetMultilineValue() {
        this._multilineValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get multilineValueInput() {
        return this._multilineValue;
    }
    get password() {
        return this.getStringAttribute('password');
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get path() {
        return this.getStringAttribute('path');
    }
    set path(value) {
        this._path = value;
    }
    // Temporarily expose input value. Use with caution.
    get pathInput() {
        return this._path;
    }
    get protectionKey() {
        return this.getStringAttribute('protection_key');
    }
    set protectionKey(value) {
        this._protectionKey = value;
    }
    resetProtectionKey() {
        this._protectionKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protectionKeyInput() {
        return this._protectionKey;
    }
    get secureAccessBastionIssuer() {
        return this.getStringAttribute('secure_access_bastion_issuer');
    }
    set secureAccessBastionIssuer(value) {
        this._secureAccessBastionIssuer = value;
    }
    resetSecureAccessBastionIssuer() {
        this._secureAccessBastionIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessBastionIssuerInput() {
        return this._secureAccessBastionIssuer;
    }
    get secureAccessEnable() {
        return this.getStringAttribute('secure_access_enable');
    }
    set secureAccessEnable(value) {
        this._secureAccessEnable = value;
    }
    resetSecureAccessEnable() {
        this._secureAccessEnable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessEnableInput() {
        return this._secureAccessEnable;
    }
    get secureAccessHost() {
        return cdktf.Fn.tolist(this.getListAttribute('secure_access_host'));
    }
    set secureAccessHost(value) {
        this._secureAccessHost = value;
    }
    resetSecureAccessHost() {
        this._secureAccessHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessHostInput() {
        return this._secureAccessHost;
    }
    get secureAccessSshCreds() {
        return this.getStringAttribute('secure_access_ssh_creds');
    }
    set secureAccessSshCreds(value) {
        this._secureAccessSshCreds = value;
    }
    resetSecureAccessSshCreds() {
        this._secureAccessSshCreds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessSshCredsInput() {
        return this._secureAccessSshCreds;
    }
    get secureAccessSshUser() {
        return this.getStringAttribute('secure_access_ssh_user');
    }
    set secureAccessSshUser(value) {
        this._secureAccessSshUser = value;
    }
    resetSecureAccessSshUser() {
        this._secureAccessSshUser = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessSshUserInput() {
        return this._secureAccessSshUser;
    }
    get secureAccessUrl() {
        return this.getStringAttribute('secure_access_url');
    }
    set secureAccessUrl(value) {
        this._secureAccessUrl = value;
    }
    resetSecureAccessUrl() {
        this._secureAccessUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessUrlInput() {
        return this._secureAccessUrl;
    }
    get secureAccessWeb() {
        return this.getBooleanAttribute('secure_access_web');
    }
    set secureAccessWeb(value) {
        this._secureAccessWeb = value;
    }
    resetSecureAccessWeb() {
        this._secureAccessWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessWebInput() {
        return this._secureAccessWeb;
    }
    get secureAccessWebBrowsing() {
        return this.getBooleanAttribute('secure_access_web_browsing');
    }
    set secureAccessWebBrowsing(value) {
        this._secureAccessWebBrowsing = value;
    }
    resetSecureAccessWebBrowsing() {
        this._secureAccessWebBrowsing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessWebBrowsingInput() {
        return this._secureAccessWebBrowsing;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get username() {
        return this.getStringAttribute('username');
    }
    set username(value) {
        this._username = value;
    }
    resetUsername() {
        this._username = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usernameInput() {
        return this._username;
    }
    get value() {
        return this.getStringAttribute('value');
    }
    set value(value) {
        this._value = value;
    }
    resetValue() {
        this._value = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get valueInput() {
        return this._value;
    }
    // version - computed: true, optional: false, required: false
    get version() {
        return this.getNumberAttribute('version');
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_field: cdktf.hashMapper(cdktf.stringToTerraform)(this._customField),
            delete_protection: cdktf.stringToTerraform(this._deleteProtection),
            description: cdktf.stringToTerraform(this._description),
            format: cdktf.stringToTerraform(this._format),
            id: cdktf.stringToTerraform(this._id),
            ignore_cache: cdktf.stringToTerraform(this._ignoreCache),
            inject_url: cdktf.listMapper(cdktf.stringToTerraform, false)(this._injectUrl),
            keep_prev_version: cdktf.stringToTerraform(this._keepPrevVersion),
            multiline_value: cdktf.booleanToTerraform(this._multilineValue),
            password: cdktf.stringToTerraform(this._password),
            path: cdktf.stringToTerraform(this._path),
            protection_key: cdktf.stringToTerraform(this._protectionKey),
            secure_access_bastion_issuer: cdktf.stringToTerraform(this._secureAccessBastionIssuer),
            secure_access_enable: cdktf.stringToTerraform(this._secureAccessEnable),
            secure_access_host: cdktf.listMapper(cdktf.stringToTerraform, false)(this._secureAccessHost),
            secure_access_ssh_creds: cdktf.stringToTerraform(this._secureAccessSshCreds),
            secure_access_ssh_user: cdktf.stringToTerraform(this._secureAccessSshUser),
            secure_access_url: cdktf.stringToTerraform(this._secureAccessUrl),
            secure_access_web: cdktf.booleanToTerraform(this._secureAccessWeb),
            secure_access_web_browsing: cdktf.booleanToTerraform(this._secureAccessWebBrowsing),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            type: cdktf.stringToTerraform(this._type),
            username: cdktf.stringToTerraform(this._username),
            value: cdktf.stringToTerraform(this._value),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            custom_field: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._customField),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            delete_protection: {
                value: cdktf.stringToHclTerraform(this._deleteProtection),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            description: {
                value: cdktf.stringToHclTerraform(this._description),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            format: {
                value: cdktf.stringToHclTerraform(this._format),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            ignore_cache: {
                value: cdktf.stringToHclTerraform(this._ignoreCache),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            inject_url: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._injectUrl),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            keep_prev_version: {
                value: cdktf.stringToHclTerraform(this._keepPrevVersion),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            multiline_value: {
                value: cdktf.booleanToHclTerraform(this._multilineValue),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            password: {
                value: cdktf.stringToHclTerraform(this._password),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            path: {
                value: cdktf.stringToHclTerraform(this._path),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            protection_key: {
                value: cdktf.stringToHclTerraform(this._protectionKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_bastion_issuer: {
                value: cdktf.stringToHclTerraform(this._secureAccessBastionIssuer),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_enable: {
                value: cdktf.stringToHclTerraform(this._secureAccessEnable),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_host: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._secureAccessHost),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            secure_access_ssh_creds: {
                value: cdktf.stringToHclTerraform(this._secureAccessSshCreds),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_ssh_user: {
                value: cdktf.stringToHclTerraform(this._secureAccessSshUser),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_url: {
                value: cdktf.stringToHclTerraform(this._secureAccessUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_web: {
                value: cdktf.booleanToHclTerraform(this._secureAccessWeb),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            secure_access_web_browsing: {
                value: cdktf.booleanToHclTerraform(this._secureAccessWebBrowsing),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            type: {
                value: cdktf.stringToHclTerraform(this._type),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            username: {
                value: cdktf.stringToHclTerraform(this._username),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            value: {
                value: cdktf.stringToHclTerraform(this._value),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.StaticSecret = StaticSecret;
_a = JSII_RTTI_SYMBOL_1;
StaticSecret[_a] = { fqn: "akeyless.staticSecret.StaticSecret", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
StaticSecret.tfResourceType = "akeyless_static_secret";
//# sourceMappingURL=data:application/json;base64,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