import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RotatedSecretSyncConfig extends cdktf.TerraformMetaArguments {
    /**
    * JQ expression to filter or transform the secret value
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#filter_secret_value RotatedSecretSync#filter_secret_value}
    */
    readonly filterSecretValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#id RotatedSecretSync#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Rotated Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#name RotatedSecretSync#name}
    */
    readonly name: string;
    /**
    * Vault namespace, releavnt only for Hashicorp Vault Target
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#namespace RotatedSecretSync#namespace}
    */
    readonly namespace?: string;
    /**
    * Remote Secret Name that will be synced on the remote endpoint
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#remote_secret_name RotatedSecretSync#remote_secret_name}
    */
    readonly remoteSecretName: string;
    /**
    * Universal Secret Connector name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#usc_name RotatedSecretSync#usc_name}
    */
    readonly uscName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync akeyless_rotated_secret_sync}
*/
export declare class RotatedSecretSync extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_rotated_secret_sync";
    /**
    * Generates CDKTF code for importing a RotatedSecretSync resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RotatedSecretSync to import
    * @param importFromId The id of the existing RotatedSecretSync that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RotatedSecretSync to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_sync akeyless_rotated_secret_sync} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatedSecretSyncConfig
    */
    constructor(scope: Construct, id: string, config: RotatedSecretSyncConfig);
    private _filterSecretValue?;
    get filterSecretValue(): string;
    set filterSecretValue(value: string);
    resetFilterSecretValue(): void;
    get filterSecretValueInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _remoteSecretName?;
    get remoteSecretName(): string;
    set remoteSecretName(value: string);
    get remoteSecretNameInput(): string | undefined;
    private _uscName?;
    get uscName(): string;
    set uscName(value: string);
    get uscNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
