import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RotatedSecretMssqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * The credentials to connect with [use-self-creds/use-target-creds]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#authentication_credentials RotatedSecretMssql#authentication_credentials}
    */
    readonly authenticationCredentials?: string;
    /**
    * Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#auto_rotate RotatedSecretMssql#auto_rotate}
    */
    readonly autoRotate?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#description RotatedSecretMssql#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#id RotatedSecretMssql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a key that is used to encrypt the secret value (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#key RotatedSecretMssql#key}
    */
    readonly key?: string;
    /**
    * Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#name RotatedSecretMssql#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#password_length RotatedSecretMssql#password_length}
    */
    readonly passwordLength?: string;
    /**
    * rotated-username password (relevant only for rotator-type=password)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#rotated_password RotatedSecretMssql#rotated_password}
    */
    readonly rotatedPassword?: string;
    /**
    * username to be rotated, if selected use-self-creds at rotator-creds-type, this username will try to rotate it's own password, if use-target-creds is selected, target credentials will be use to rotate the rotated-password (relevant only for rotator-type=password)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#rotated_username RotatedSecretMssql#rotated_username}
    */
    readonly rotatedUsername?: string;
    /**
    * The Hour of the rotation in UTC
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#rotation_hour RotatedSecretMssql#rotation_hour}
    */
    readonly rotationHour?: number;
    /**
    * The number of days to wait between every automatic rotation (1-365),custom rotator interval will be set in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#rotation_interval RotatedSecretMssql#rotation_interval}
    */
    readonly rotationInterval?: string;
    /**
    * The rotator type [target/password]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#rotator_type RotatedSecretMssql#rotator_type}
    */
    readonly rotatorType: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#tags RotatedSecretMssql#tags}
    */
    readonly tags?: string[];
    /**
    * The target name to associate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#target_name RotatedSecretMssql#target_name}
    */
    readonly targetName: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql akeyless_rotated_secret_mssql}
*/
export declare class RotatedSecretMssql extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_rotated_secret_mssql";
    /**
    * Generates CDKTF code for importing a RotatedSecretMssql resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the RotatedSecretMssql to import
    * @param importFromId The id of the existing RotatedSecretMssql that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the RotatedSecretMssql to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/rotated_secret_mssql akeyless_rotated_secret_mssql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RotatedSecretMssqlConfig
    */
    constructor(scope: Construct, id: string, config: RotatedSecretMssqlConfig);
    private _authenticationCredentials?;
    get authenticationCredentials(): string;
    set authenticationCredentials(value: string);
    resetAuthenticationCredentials(): void;
    get authenticationCredentialsInput(): string | undefined;
    private _autoRotate?;
    get autoRotate(): string;
    set autoRotate(value: string);
    resetAutoRotate(): void;
    get autoRotateInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _rotatedPassword?;
    get rotatedPassword(): string;
    set rotatedPassword(value: string);
    resetRotatedPassword(): void;
    get rotatedPasswordInput(): string | undefined;
    private _rotatedUsername?;
    get rotatedUsername(): string;
    set rotatedUsername(value: string);
    resetRotatedUsername(): void;
    get rotatedUsernameInput(): string | undefined;
    private _rotationHour?;
    get rotationHour(): number;
    set rotationHour(value: number);
    resetRotationHour(): void;
    get rotationHourInput(): number | undefined;
    private _rotationInterval?;
    get rotationInterval(): string;
    set rotationInterval(value: string);
    resetRotationInterval(): void;
    get rotationIntervalInput(): string | undefined;
    private _rotatorType?;
    get rotatorType(): string;
    set rotatorType(value: string);
    get rotatorTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    get targetNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
