import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerPostgresConfig extends cdktf.TerraformMetaArguments {
    /**
    * PostgreSQL Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#creation_statements ProducerPostgres#creation_statements}
    */
    readonly creationStatements?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#id ProducerPostgres#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#name ProducerPostgres#name}
    */
    readonly name: string;
    /**
    * PostgreSQL DB name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#postgresql_db_name ProducerPostgres#postgresql_db_name}
    */
    readonly postgresqlDbName?: string;
    /**
    * PostgreSQL host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#postgresql_host ProducerPostgres#postgresql_host}
    */
    readonly postgresqlHost?: string;
    /**
    * PostgreSQL password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#postgresql_password ProducerPostgres#postgresql_password}
    */
    readonly postgresqlPassword?: string;
    /**
    * PostgreSQL port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#postgresql_port ProducerPostgres#postgresql_port}
    */
    readonly postgresqlPort?: string;
    /**
    * PostgreSQL user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#postgresql_username ProducerPostgres#postgresql_username}
    */
    readonly postgresqlUsername?: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#producer_encryption_key ProducerPostgres#producer_encryption_key}
    */
    readonly producerEncryptionKey?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#secure_access_bastion_issuer ProducerPostgres#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#secure_access_db_name ProducerPostgres#secure_access_db_name}
    */
    readonly secureAccessDbName?: string;
    /**
    * The db schema
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#secure_access_db_schema ProducerPostgres#secure_access_db_schema}
    */
    readonly secureAccessDbSchema?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#secure_access_enable ProducerPostgres#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target DB servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#secure_access_host ProducerPostgres#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#secure_access_web ProducerPostgres#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#tags ProducerPostgres#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#target_name ProducerPostgres#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#user_ttl ProducerPostgres#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres akeyless_producer_postgres}
*/
export declare class ProducerPostgres extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_postgres";
    /**
    * Generates CDKTF code for importing a ProducerPostgres resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerPostgres to import
    * @param importFromId The id of the existing ProducerPostgres that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerPostgres to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_postgres akeyless_producer_postgres} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerPostgresConfig
    */
    constructor(scope: Construct, id: string, config: ProducerPostgresConfig);
    private _creationStatements?;
    get creationStatements(): string;
    set creationStatements(value: string);
    resetCreationStatements(): void;
    get creationStatementsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _postgresqlDbName?;
    get postgresqlDbName(): string;
    set postgresqlDbName(value: string);
    resetPostgresqlDbName(): void;
    get postgresqlDbNameInput(): string | undefined;
    private _postgresqlHost?;
    get postgresqlHost(): string;
    set postgresqlHost(value: string);
    resetPostgresqlHost(): void;
    get postgresqlHostInput(): string | undefined;
    private _postgresqlPassword?;
    get postgresqlPassword(): string;
    set postgresqlPassword(value: string);
    resetPostgresqlPassword(): void;
    get postgresqlPasswordInput(): string | undefined;
    private _postgresqlPort?;
    get postgresqlPort(): string;
    set postgresqlPort(value: string);
    resetPostgresqlPort(): void;
    get postgresqlPortInput(): string | undefined;
    private _postgresqlUsername?;
    get postgresqlUsername(): string;
    set postgresqlUsername(value: string);
    resetPostgresqlUsername(): void;
    get postgresqlUsernameInput(): string | undefined;
    private _producerEncryptionKey?;
    get producerEncryptionKey(): string;
    set producerEncryptionKey(value: string);
    resetProducerEncryptionKey(): void;
    get producerEncryptionKeyInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessDbName?;
    get secureAccessDbName(): string;
    set secureAccessDbName(value: string);
    resetSecureAccessDbName(): void;
    get secureAccessDbNameInput(): string | undefined;
    private _secureAccessDbSchema?;
    get secureAccessDbSchema(): string;
    set secureAccessDbSchema(value: string);
    resetSecureAccessDbSchema(): void;
    get secureAccessDbSchemaInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
