import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerMysqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * the set of root certificate authorities in base64 encoding that clients use when verifying server certificates
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#db_server_certificates ProducerMysql#db_server_certificates}
    */
    readonly dbServerCertificates?: string;
    /**
    * Server name is used to verify the hostname on the returned certificates unless InsecureSkipVerify is given. It is also included in the client's handshake to support virtual hosting unless it is an IP address
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#db_server_name ProducerMysql#db_server_name}
    */
    readonly dbServerName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#id ProducerMysql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * MySQL DB name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#mysql_dbname ProducerMysql#mysql_dbname}
    */
    readonly mysqlDbname?: string;
    /**
    * MySQL host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#mysql_host ProducerMysql#mysql_host}
    */
    readonly mysqlHost?: string;
    /**
    * MySQL password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#mysql_password ProducerMysql#mysql_password}
    */
    readonly mysqlPassword?: string;
    /**
    * MySQL port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#mysql_port ProducerMysql#mysql_port}
    */
    readonly mysqlPort?: string;
    /**
    * MySQL Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#mysql_screation_statements ProducerMysql#mysql_screation_statements}
    */
    readonly mysqlScreationStatements?: string;
    /**
    * MySQL user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#mysql_username ProducerMysql#mysql_username}
    */
    readonly mysqlUsername?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#name ProducerMysql#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#producer_encryption_key_name ProducerMysql#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#secure_access_bastion_issuer ProducerMysql#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#secure_access_db_name ProducerMysql#secure_access_db_name}
    */
    readonly secureAccessDbName?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#secure_access_enable ProducerMysql#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target DB servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#secure_access_host ProducerMysql#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#secure_access_web ProducerMysql#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#tags ProducerMysql#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#target_name ProducerMysql#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#user_ttl ProducerMysql#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql akeyless_producer_mysql}
*/
export declare class ProducerMysql extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_mysql";
    /**
    * Generates CDKTF code for importing a ProducerMysql resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerMysql to import
    * @param importFromId The id of the existing ProducerMysql that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerMysql to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mysql akeyless_producer_mysql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerMysqlConfig
    */
    constructor(scope: Construct, id: string, config: ProducerMysqlConfig);
    private _dbServerCertificates?;
    get dbServerCertificates(): string;
    set dbServerCertificates(value: string);
    resetDbServerCertificates(): void;
    get dbServerCertificatesInput(): string | undefined;
    private _dbServerName?;
    get dbServerName(): string;
    set dbServerName(value: string);
    resetDbServerName(): void;
    get dbServerNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mysqlDbname?;
    get mysqlDbname(): string;
    set mysqlDbname(value: string);
    resetMysqlDbname(): void;
    get mysqlDbnameInput(): string | undefined;
    private _mysqlHost?;
    get mysqlHost(): string;
    set mysqlHost(value: string);
    resetMysqlHost(): void;
    get mysqlHostInput(): string | undefined;
    private _mysqlPassword?;
    get mysqlPassword(): string;
    set mysqlPassword(value: string);
    resetMysqlPassword(): void;
    get mysqlPasswordInput(): string | undefined;
    private _mysqlPort?;
    get mysqlPort(): string;
    set mysqlPort(value: string);
    resetMysqlPort(): void;
    get mysqlPortInput(): string | undefined;
    private _mysqlScreationStatements?;
    get mysqlScreationStatements(): string;
    set mysqlScreationStatements(value: string);
    resetMysqlScreationStatements(): void;
    get mysqlScreationStatementsInput(): string | undefined;
    private _mysqlUsername?;
    get mysqlUsername(): string;
    set mysqlUsername(value: string);
    resetMysqlUsername(): void;
    get mysqlUsernameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessDbName?;
    get secureAccessDbName(): string;
    set secureAccessDbName(value: string);
    resetSecureAccessDbName(): void;
    get secureAccessDbNameInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
