import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerMssqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#id ProducerMssql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * MSSQL Server Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_create_statements ProducerMssql#mssql_create_statements}
    */
    readonly mssqlCreateStatements?: string;
    /**
    * MSSQL Server DB Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_dbname ProducerMssql#mssql_dbname}
    */
    readonly mssqlDbname?: string;
    /**
    * MS SQL Server host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_host ProducerMssql#mssql_host}
    */
    readonly mssqlHost?: string;
    /**
    * MS SQL Server password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_password ProducerMssql#mssql_password}
    */
    readonly mssqlPassword?: string;
    /**
    * MS SQL Server port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_port ProducerMssql#mssql_port}
    */
    readonly mssqlPort?: string;
    /**
    * MSSQL Server Revocation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_revocation_statements ProducerMssql#mssql_revocation_statements}
    */
    readonly mssqlRevocationStatements?: string;
    /**
    * MS SQL Server user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#mssql_username ProducerMssql#mssql_username}
    */
    readonly mssqlUsername?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#name ProducerMssql#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#producer_encryption_key_name ProducerMssql#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#secure_access_bastion_issuer ProducerMssql#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#secure_access_db_name ProducerMssql#secure_access_db_name}
    */
    readonly secureAccessDbName?: string;
    /**
    * The db schema
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#secure_access_db_schema ProducerMssql#secure_access_db_schema}
    */
    readonly secureAccessDbSchema?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#secure_access_enable ProducerMssql#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target DB servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#secure_access_host ProducerMssql#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#secure_access_web ProducerMssql#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#tags ProducerMssql#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#target_name ProducerMssql#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#user_ttl ProducerMssql#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql akeyless_producer_mssql}
*/
export declare class ProducerMssql extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_mssql";
    /**
    * Generates CDKTF code for importing a ProducerMssql resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerMssql to import
    * @param importFromId The id of the existing ProducerMssql that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerMssql to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mssql akeyless_producer_mssql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerMssqlConfig
    */
    constructor(scope: Construct, id: string, config: ProducerMssqlConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mssqlCreateStatements?;
    get mssqlCreateStatements(): string;
    set mssqlCreateStatements(value: string);
    resetMssqlCreateStatements(): void;
    get mssqlCreateStatementsInput(): string | undefined;
    private _mssqlDbname?;
    get mssqlDbname(): string;
    set mssqlDbname(value: string);
    resetMssqlDbname(): void;
    get mssqlDbnameInput(): string | undefined;
    private _mssqlHost?;
    get mssqlHost(): string;
    set mssqlHost(value: string);
    resetMssqlHost(): void;
    get mssqlHostInput(): string | undefined;
    private _mssqlPassword?;
    get mssqlPassword(): string;
    set mssqlPassword(value: string);
    resetMssqlPassword(): void;
    get mssqlPasswordInput(): string | undefined;
    private _mssqlPort?;
    get mssqlPort(): string;
    set mssqlPort(value: string);
    resetMssqlPort(): void;
    get mssqlPortInput(): string | undefined;
    private _mssqlRevocationStatements?;
    get mssqlRevocationStatements(): string;
    set mssqlRevocationStatements(value: string);
    resetMssqlRevocationStatements(): void;
    get mssqlRevocationStatementsInput(): string | undefined;
    private _mssqlUsername?;
    get mssqlUsername(): string;
    set mssqlUsername(value: string);
    resetMssqlUsername(): void;
    get mssqlUsernameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessDbName?;
    get secureAccessDbName(): string;
    set secureAccessDbName(value: string);
    resetSecureAccessDbName(): void;
    get secureAccessDbNameInput(): string | undefined;
    private _secureAccessDbSchema?;
    get secureAccessDbSchema(): string;
    set secureAccessDbSchema(value: string);
    resetSecureAccessDbSchema(): void;
    get secureAccessDbSchemaInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
