"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProducerMongo = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo akeyless_producer_mongo}
*/
class ProducerMongo extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a ProducerMongo resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerMongo to import
    * @param importFromId The id of the existing ProducerMongo that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerMongo to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "akeyless_producer_mongo", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_mongo akeyless_producer_mongo} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerMongoConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'akeyless_producer_mongo',
            terraformGeneratorMetadata: {
                providerName: 'akeyless',
                providerVersion: '1.11.2',
                providerVersionConstraint: '~> 1.11.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._id = config.id;
        this._mongodbAtlasApiPrivateKey = config.mongodbAtlasApiPrivateKey;
        this._mongodbAtlasApiPublicKey = config.mongodbAtlasApiPublicKey;
        this._mongodbAtlasProjectId = config.mongodbAtlasProjectId;
        this._mongodbDefaultAuthDb = config.mongodbDefaultAuthDb;
        this._mongodbHostPort = config.mongodbHostPort;
        this._mongodbName = config.mongodbName;
        this._mongodbPassword = config.mongodbPassword;
        this._mongodbRoles = config.mongodbRoles;
        this._mongodbServerUri = config.mongodbServerUri;
        this._mongodbUriOptions = config.mongodbUriOptions;
        this._mongodbUsername = config.mongodbUsername;
        this._name = config.name;
        this._producerEncryptionKeyName = config.producerEncryptionKeyName;
        this._secureAccessBastionIssuer = config.secureAccessBastionIssuer;
        this._secureAccessDbName = config.secureAccessDbName;
        this._secureAccessEnable = config.secureAccessEnable;
        this._secureAccessHost = config.secureAccessHost;
        this._secureAccessWeb = config.secureAccessWeb;
        this._tags = config.tags;
        this._targetName = config.targetName;
        this._userTtl = config.userTtl;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get mongodbAtlasApiPrivateKey() {
        return this.getStringAttribute('mongodb_atlas_api_private_key');
    }
    set mongodbAtlasApiPrivateKey(value) {
        this._mongodbAtlasApiPrivateKey = value;
    }
    resetMongodbAtlasApiPrivateKey() {
        this._mongodbAtlasApiPrivateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbAtlasApiPrivateKeyInput() {
        return this._mongodbAtlasApiPrivateKey;
    }
    get mongodbAtlasApiPublicKey() {
        return this.getStringAttribute('mongodb_atlas_api_public_key');
    }
    set mongodbAtlasApiPublicKey(value) {
        this._mongodbAtlasApiPublicKey = value;
    }
    resetMongodbAtlasApiPublicKey() {
        this._mongodbAtlasApiPublicKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbAtlasApiPublicKeyInput() {
        return this._mongodbAtlasApiPublicKey;
    }
    get mongodbAtlasProjectId() {
        return this.getStringAttribute('mongodb_atlas_project_id');
    }
    set mongodbAtlasProjectId(value) {
        this._mongodbAtlasProjectId = value;
    }
    resetMongodbAtlasProjectId() {
        this._mongodbAtlasProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbAtlasProjectIdInput() {
        return this._mongodbAtlasProjectId;
    }
    get mongodbDefaultAuthDb() {
        return this.getStringAttribute('mongodb_default_auth_db');
    }
    set mongodbDefaultAuthDb(value) {
        this._mongodbDefaultAuthDb = value;
    }
    resetMongodbDefaultAuthDb() {
        this._mongodbDefaultAuthDb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbDefaultAuthDbInput() {
        return this._mongodbDefaultAuthDb;
    }
    get mongodbHostPort() {
        return this.getStringAttribute('mongodb_host_port');
    }
    set mongodbHostPort(value) {
        this._mongodbHostPort = value;
    }
    resetMongodbHostPort() {
        this._mongodbHostPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbHostPortInput() {
        return this._mongodbHostPort;
    }
    get mongodbName() {
        return this.getStringAttribute('mongodb_name');
    }
    set mongodbName(value) {
        this._mongodbName = value;
    }
    resetMongodbName() {
        this._mongodbName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbNameInput() {
        return this._mongodbName;
    }
    get mongodbPassword() {
        return this.getStringAttribute('mongodb_password');
    }
    set mongodbPassword(value) {
        this._mongodbPassword = value;
    }
    resetMongodbPassword() {
        this._mongodbPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbPasswordInput() {
        return this._mongodbPassword;
    }
    get mongodbRoles() {
        return this.getStringAttribute('mongodb_roles');
    }
    set mongodbRoles(value) {
        this._mongodbRoles = value;
    }
    resetMongodbRoles() {
        this._mongodbRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbRolesInput() {
        return this._mongodbRoles;
    }
    get mongodbServerUri() {
        return this.getStringAttribute('mongodb_server_uri');
    }
    set mongodbServerUri(value) {
        this._mongodbServerUri = value;
    }
    resetMongodbServerUri() {
        this._mongodbServerUri = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbServerUriInput() {
        return this._mongodbServerUri;
    }
    get mongodbUriOptions() {
        return this.getStringAttribute('mongodb_uri_options');
    }
    set mongodbUriOptions(value) {
        this._mongodbUriOptions = value;
    }
    resetMongodbUriOptions() {
        this._mongodbUriOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbUriOptionsInput() {
        return this._mongodbUriOptions;
    }
    get mongodbUsername() {
        return this.getStringAttribute('mongodb_username');
    }
    set mongodbUsername(value) {
        this._mongodbUsername = value;
    }
    resetMongodbUsername() {
        this._mongodbUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbUsernameInput() {
        return this._mongodbUsername;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get producerEncryptionKeyName() {
        return this.getStringAttribute('producer_encryption_key_name');
    }
    set producerEncryptionKeyName(value) {
        this._producerEncryptionKeyName = value;
    }
    resetProducerEncryptionKeyName() {
        this._producerEncryptionKeyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get producerEncryptionKeyNameInput() {
        return this._producerEncryptionKeyName;
    }
    get secureAccessBastionIssuer() {
        return this.getStringAttribute('secure_access_bastion_issuer');
    }
    set secureAccessBastionIssuer(value) {
        this._secureAccessBastionIssuer = value;
    }
    resetSecureAccessBastionIssuer() {
        this._secureAccessBastionIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessBastionIssuerInput() {
        return this._secureAccessBastionIssuer;
    }
    get secureAccessDbName() {
        return this.getStringAttribute('secure_access_db_name');
    }
    set secureAccessDbName(value) {
        this._secureAccessDbName = value;
    }
    resetSecureAccessDbName() {
        this._secureAccessDbName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessDbNameInput() {
        return this._secureAccessDbName;
    }
    get secureAccessEnable() {
        return this.getStringAttribute('secure_access_enable');
    }
    set secureAccessEnable(value) {
        this._secureAccessEnable = value;
    }
    resetSecureAccessEnable() {
        this._secureAccessEnable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessEnableInput() {
        return this._secureAccessEnable;
    }
    get secureAccessHost() {
        return cdktf.Fn.tolist(this.getListAttribute('secure_access_host'));
    }
    set secureAccessHost(value) {
        this._secureAccessHost = value;
    }
    resetSecureAccessHost() {
        this._secureAccessHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessHostInput() {
        return this._secureAccessHost;
    }
    get secureAccessWeb() {
        return this.getBooleanAttribute('secure_access_web');
    }
    set secureAccessWeb(value) {
        this._secureAccessWeb = value;
    }
    resetSecureAccessWeb() {
        this._secureAccessWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessWebInput() {
        return this._secureAccessWeb;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get targetName() {
        return this.getStringAttribute('target_name');
    }
    set targetName(value) {
        this._targetName = value;
    }
    resetTargetName() {
        this._targetName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get targetNameInput() {
        return this._targetName;
    }
    get userTtl() {
        return this.getStringAttribute('user_ttl');
    }
    set userTtl(value) {
        this._userTtl = value;
    }
    resetUserTtl() {
        this._userTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTtlInput() {
        return this._userTtl;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            id: cdktf.stringToTerraform(this._id),
            mongodb_atlas_api_private_key: cdktf.stringToTerraform(this._mongodbAtlasApiPrivateKey),
            mongodb_atlas_api_public_key: cdktf.stringToTerraform(this._mongodbAtlasApiPublicKey),
            mongodb_atlas_project_id: cdktf.stringToTerraform(this._mongodbAtlasProjectId),
            mongodb_default_auth_db: cdktf.stringToTerraform(this._mongodbDefaultAuthDb),
            mongodb_host_port: cdktf.stringToTerraform(this._mongodbHostPort),
            mongodb_name: cdktf.stringToTerraform(this._mongodbName),
            mongodb_password: cdktf.stringToTerraform(this._mongodbPassword),
            mongodb_roles: cdktf.stringToTerraform(this._mongodbRoles),
            mongodb_server_uri: cdktf.stringToTerraform(this._mongodbServerUri),
            mongodb_uri_options: cdktf.stringToTerraform(this._mongodbUriOptions),
            mongodb_username: cdktf.stringToTerraform(this._mongodbUsername),
            name: cdktf.stringToTerraform(this._name),
            producer_encryption_key_name: cdktf.stringToTerraform(this._producerEncryptionKeyName),
            secure_access_bastion_issuer: cdktf.stringToTerraform(this._secureAccessBastionIssuer),
            secure_access_db_name: cdktf.stringToTerraform(this._secureAccessDbName),
            secure_access_enable: cdktf.stringToTerraform(this._secureAccessEnable),
            secure_access_host: cdktf.listMapper(cdktf.stringToTerraform, false)(this._secureAccessHost),
            secure_access_web: cdktf.booleanToTerraform(this._secureAccessWeb),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            target_name: cdktf.stringToTerraform(this._targetName),
            user_ttl: cdktf.stringToTerraform(this._userTtl),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_atlas_api_private_key: {
                value: cdktf.stringToHclTerraform(this._mongodbAtlasApiPrivateKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_atlas_api_public_key: {
                value: cdktf.stringToHclTerraform(this._mongodbAtlasApiPublicKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_atlas_project_id: {
                value: cdktf.stringToHclTerraform(this._mongodbAtlasProjectId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_default_auth_db: {
                value: cdktf.stringToHclTerraform(this._mongodbDefaultAuthDb),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_host_port: {
                value: cdktf.stringToHclTerraform(this._mongodbHostPort),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_name: {
                value: cdktf.stringToHclTerraform(this._mongodbName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_password: {
                value: cdktf.stringToHclTerraform(this._mongodbPassword),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_roles: {
                value: cdktf.stringToHclTerraform(this._mongodbRoles),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_server_uri: {
                value: cdktf.stringToHclTerraform(this._mongodbServerUri),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_uri_options: {
                value: cdktf.stringToHclTerraform(this._mongodbUriOptions),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_username: {
                value: cdktf.stringToHclTerraform(this._mongodbUsername),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            producer_encryption_key_name: {
                value: cdktf.stringToHclTerraform(this._producerEncryptionKeyName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_bastion_issuer: {
                value: cdktf.stringToHclTerraform(this._secureAccessBastionIssuer),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_db_name: {
                value: cdktf.stringToHclTerraform(this._secureAccessDbName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_enable: {
                value: cdktf.stringToHclTerraform(this._secureAccessEnable),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_host: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._secureAccessHost),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            secure_access_web: {
                value: cdktf.booleanToHclTerraform(this._secureAccessWeb),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            target_name: {
                value: cdktf.stringToHclTerraform(this._targetName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_ttl: {
                value: cdktf.stringToHclTerraform(this._userTtl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.ProducerMongo = ProducerMongo;
_a = JSII_RTTI_SYMBOL_1;
ProducerMongo[_a] = { fqn: "akeyless.producerMongo.ProducerMongo", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
ProducerMongo.tfResourceType = "akeyless_producer_mongo";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBLCtCQUErQjtBQTRJL0I7O0VBRUU7QUFDRixNQUFhLGFBQWMsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBT3hELGlCQUFpQjtJQUNqQixpQkFBaUI7SUFDakIsaUJBQWlCO0lBQ2pCOzs7Ozs7TUFNRTtJQUNLLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQyxLQUFnQixFQUFFLFVBQWtCLEVBQUUsWUFBb0IsRUFBRSxRQUFrQztRQUM5SCxPQUFPLElBQUksS0FBSyxDQUFDLGtCQUFrQixDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsRUFBRSxxQkFBcUIsRUFBRSx5QkFBeUIsRUFBRSxRQUFRLEVBQUUsWUFBWSxFQUFFLFFBQVEsRUFBRSxDQUFDLENBQUM7SUFDakosQ0FBQztJQUVMLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQTJCO1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUseUJBQXlCO1lBQ2hELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsVUFBVTtnQkFDeEIsZUFBZSxFQUFFLFFBQVE7Z0JBQ3pCLHlCQUF5QixFQUFFLFdBQVc7YUFDdkM7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsWUFBWSxFQUFFLE1BQU0sQ0FBQyxZQUFZO1lBQ2pDLFVBQVUsRUFBRSxNQUFNLENBQUMsVUFBVTtZQUM3QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU87U0FDeEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLEdBQUcsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLHlCQUF5QixHQUFHLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQztRQUNqRSxJQUFJLENBQUMsc0JBQXNCLEdBQUcsTUFBTSxDQUFDLHFCQUFxQixDQUFDO1FBQzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLGdCQUFnQixHQUFHLE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDL0MsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQywwQkFBMEIsR0FBRyxNQUFNLENBQUMseUJBQXlCLENBQUM7UUFDbkUsSUFBSSxDQUFDLDBCQUEwQixHQUFHLE1BQU0sQ0FBQyx5QkFBeUIsQ0FBQztRQUNuRSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3JELElBQUksQ0FBQyxtQkFBbUIsR0FBRyxNQUFNLENBQUMsa0JBQWtCLENBQUM7UUFDckQsSUFBSSxDQUFDLGlCQUFpQixHQUFHLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsTUFBTSxDQUFDLGVBQWUsQ0FBQztRQUMvQyxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztJQUNqQyxDQUFDO0lBUUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUNELElBQVcseUJBQXlCLENBQUMsS0FBYTtRQUNoRCxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSw4QkFBOEI7UUFDbkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOEJBQThCO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLHdCQUF3QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pFLENBQUM7SUFDRCxJQUFXLHdCQUF3QixDQUFDLEtBQWE7UUFDL0MsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQztJQUN6QyxDQUFDO0lBQ00sNkJBQTZCO1FBQ2xDLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxTQUFTLENBQUM7SUFDN0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDZCQUE2QjtRQUN0QyxPQUFPLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztJQUN4QyxDQUFDO0lBSUQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBQ0QsSUFBVyxxQkFBcUIsQ0FBQyxLQUFhO1FBQzVDLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUNNLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsU0FBUyxDQUFDO0lBQzFDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywwQkFBMEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHlCQUF5QixDQUFDLENBQUM7SUFDNUQsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBYTtRQUMzQyxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbUJBQW1CLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBQ0QsSUFBVyxlQUFlLENBQUMsS0FBYTtRQUN0QyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDO0lBQ2hDLENBQUM7SUFDTSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLGdCQUFnQixHQUFHLFNBQVMsQ0FBQztJQUNwQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDO0lBQy9CLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWE7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUFhO1FBQ25DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUlELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLG9CQUFvQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZ0JBQWdCLENBQUMsS0FBYTtRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDO0lBQ2pDLENBQUM7SUFDTSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLGlCQUFpQixHQUFHLFNBQVMsQ0FBQztJQUNyQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcscUJBQXFCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixDQUFDO0lBQ2hDLENBQUM7SUFJRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFDRCxJQUFXLGlCQUFpQixDQUFDLEtBQWE7UUFDeEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDO0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWE7UUFDdEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQztJQUNoQyxDQUFDO0lBQ00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxTQUFTLENBQUM7SUFDcEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUMvQixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQ3BCLENBQUM7SUFJRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO0lBQ2pFLENBQUM7SUFDRCxJQUFXLHlCQUF5QixDQUFDLEtBQWE7UUFDaEQsSUFBSSxDQUFDLDBCQUEwQixHQUFHLEtBQUssQ0FBQztJQUMxQyxDQUFDO0lBQ00sOEJBQThCO1FBQ25DLElBQUksQ0FBQywwQkFBMEIsR0FBRyxTQUFTLENBQUM7SUFDOUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDhCQUE4QjtRQUN2QyxPQUFPLElBQUksQ0FBQywwQkFBMEIsQ0FBQztJQUN6QyxDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBQ0QsSUFBVyx5QkFBeUIsQ0FBQyxLQUFhO1FBQ2hELElBQUksQ0FBQywwQkFBMEIsR0FBRyxLQUFLLENBQUM7SUFDMUMsQ0FBQztJQUNNLDhCQUE4QjtRQUNuQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsU0FBUyxDQUFDO0lBQzlDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyw4QkFBOEI7UUFDdkMsT0FBTyxJQUFJLENBQUMsMEJBQTBCLENBQUM7SUFDekMsQ0FBQztJQUlELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUQsQ0FBQztJQUNELElBQVcsa0JBQWtCLENBQUMsS0FBYTtRQUN6QyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDO0lBQ25DLENBQUM7SUFDTSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLG1CQUFtQixHQUFHLFNBQVMsQ0FBQztJQUN2QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsdUJBQXVCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDO0lBQ2xDLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQWE7UUFDekMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7SUFDdkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxLQUFLLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ3RFLENBQUM7SUFDRCxJQUFXLGdCQUFnQixDQUFDLEtBQWU7UUFDekMsSUFBSSxDQUFDLGlCQUFpQixHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0lBQ00scUJBQXFCO1FBQzFCLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxTQUFTLENBQUM7SUFDckMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdkQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWtDO1FBQzNELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sS0FBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7SUFDeEQsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWU7UUFDN0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRCxDQUFDO0lBQ0QsSUFBVyxVQUFVLENBQUMsS0FBYTtRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQztJQUMzQixDQUFDO0lBQ00sZUFBZTtRQUNwQixJQUFJLENBQUMsV0FBVyxHQUFHLFNBQVMsQ0FBQztJQUMvQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZUFBZTtRQUN4QixPQUFPLElBQUksQ0FBQyxXQUFXLENBQUM7SUFDMUIsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxHQUFHLFNBQVMsQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsRUFBRSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1lBQ3JDLDZCQUE2QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFDdkYsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQztZQUNyRix3QkFBd0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHNCQUFzQixDQUFDO1lBQzlFLHVCQUF1QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7WUFDNUUsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUNqRSxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUNoRSxhQUFhLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUM7WUFDMUQsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztZQUNuRSxtQkFBbUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGtCQUFrQixDQUFDO1lBQ3JFLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7WUFDaEUsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLDRCQUE0QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFDdEYsNEJBQTRCLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQywwQkFBMEIsQ0FBQztZQUN0RixxQkFBcUIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ3hFLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7WUFDdkUsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQzVGLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7WUFDbEUsSUFBSSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDbEUsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELFFBQVEsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztTQUNqRCxDQUFDO0lBQ0osQ0FBQztJQUVTLHVCQUF1QjtRQUMvQixNQUFNLEtBQUssR0FBRztZQUNaLEVBQUUsRUFBRTtnQkFDRixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxHQUFHLENBQUM7Z0JBQzNDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCw2QkFBNkIsRUFBRTtnQkFDN0IsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7Z0JBQ2xFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCw0QkFBNEIsRUFBRTtnQkFDNUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUM7Z0JBQ2pFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCx3QkFBd0IsRUFBRTtnQkFDeEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsc0JBQXNCLENBQUM7Z0JBQzlELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCx1QkFBdUIsRUFBRTtnQkFDdkIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7Z0JBQzdELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxpQkFBaUIsRUFBRTtnQkFDakIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7Z0JBQ3hELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxZQUFZLEVBQUU7Z0JBQ1osS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO2dCQUNwRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsZ0JBQWdCLEVBQUU7Z0JBQ2hCLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDO2dCQUN4RCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1lBQ0QsYUFBYSxFQUFFO2dCQUNiLEtBQUssRUFBRSxLQUFLLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQztnQkFDckQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGtCQUFrQixFQUFFO2dCQUNsQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztnQkFDekQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELG1CQUFtQixFQUFFO2dCQUNuQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztnQkFDMUQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELGdCQUFnQixFQUFFO2dCQUNoQixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDeEQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsUUFBUTthQUMzQjtZQUNELElBQUksRUFBRTtnQkFDSixLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7Z0JBQzdDLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCw0QkFBNEIsRUFBRTtnQkFDNUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7Z0JBQ2xFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCw0QkFBNEIsRUFBRTtnQkFDNUIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7Z0JBQ2xFLE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQzNELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxvQkFBb0IsRUFBRTtnQkFDcEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUM7Z0JBQzNELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxrQkFBa0IsRUFBRTtnQkFDbEIsS0FBSyxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztnQkFDckYsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLEtBQUs7Z0JBQ1gsZ0JBQWdCLEVBQUUsWUFBWTthQUMvQjtZQUNELGlCQUFpQixFQUFFO2dCQUNqQixLQUFLLEVBQUUsS0FBSyxDQUFDLHFCQUFxQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDekQsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLFFBQVE7Z0JBQ2QsZ0JBQWdCLEVBQUUsU0FBUzthQUM1QjtZQUNELElBQUksRUFBRTtnQkFDSixLQUFLLEVBQUUsS0FBSyxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUMsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztnQkFDekUsT0FBTyxFQUFFLEtBQUs7Z0JBQ2QsSUFBSSxFQUFFLEtBQUs7Z0JBQ1gsZ0JBQWdCLEVBQUUsWUFBWTthQUMvQjtZQUNELFdBQVcsRUFBRTtnQkFDWCxLQUFLLEVBQUUsS0FBSyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUM7Z0JBQ25ELE9BQU8sRUFBRSxLQUFLO2dCQUNkLElBQUksRUFBRSxRQUFRO2dCQUNkLGdCQUFnQixFQUFFLFFBQVE7YUFDM0I7WUFDRCxRQUFRLEVBQUU7Z0JBQ1IsS0FBSyxFQUFFLEtBQUssQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO2dCQUNoRCxPQUFPLEVBQUUsS0FBSztnQkFDZCxJQUFJLEVBQUUsUUFBUTtnQkFDZCxnQkFBZ0IsRUFBRSxRQUFRO2FBQzNCO1NBQ0YsQ0FBQztRQUVGLDhCQUE4QjtRQUM5QixPQUFPLE1BQU0sQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsRUFBRSxFQUFFLENBQUMsS0FBSyxLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMsS0FBSyxLQUFLLFNBQVMsQ0FBRSxDQUFDLENBQUE7SUFDNUgsQ0FBQzs7QUFsbEJILHNDQW1sQkM7OztBQWpsQkMsb0JBQW9CO0FBQ3BCLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDRyw0QkFBYyxHQUFHLHlCQUF5QixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2FrZXlsZXNzLWNvbW11bml0eS9ha2V5bGVzcy8xLjExLjIvZG9jcy9yZXNvdXJjZXMvcHJvZHVjZXJfbW9uZ29cbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBQcm9kdWNlck1vbmdvQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2FrZXlsZXNzLWNvbW11bml0eS9ha2V5bGVzcy8xLjExLjIvZG9jcy9yZXNvdXJjZXMvcHJvZHVjZXJfbW9uZ28jaWQgUHJvZHVjZXJNb25nbyNpZH1cbiAgKlxuICAqIFBsZWFzZSBiZSBhd2FyZSB0aGF0IHRoZSBpZCBmaWVsZCBpcyBhdXRvbWF0aWNhbGx5IGFkZGVkIHRvIGFsbCByZXNvdXJjZXMgaW4gVGVycmFmb3JtIHByb3ZpZGVycyB1c2luZyBhIFRlcnJhZm9ybSBwcm92aWRlciBTREsgdmVyc2lvbiBiZWxvdyAyLlxuICAqIElmIHlvdSBleHBlcmllbmNlIHByb2JsZW1zIHNldHRpbmcgdGhpcyB2YWx1ZSBpdCBtaWdodCBub3QgYmUgc2V0dGFibGUuIFBsZWFzZSB0YWtlIGEgbG9vayBhdCB0aGUgcHJvdmlkZXIgZG9jdW1lbnRhdGlvbiB0byBlbnN1cmUgaXQgc2hvdWxkIGJlIHNldHRhYmxlLlxuICAqL1xuICByZWFkb25seSBpZD86IHN0cmluZztcbiAgLyoqXG4gICogTW9uZ29EQiBBdGxhcyBwcml2YXRlIGtleVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyNtb25nb2RiX2F0bGFzX2FwaV9wcml2YXRlX2tleSBQcm9kdWNlck1vbmdvI21vbmdvZGJfYXRsYXNfYXBpX3ByaXZhdGVfa2V5fVxuICAqL1xuICByZWFkb25seSBtb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5Pzogc3RyaW5nO1xuICAvKipcbiAgKiBNb25nb0RCIEF0bGFzIHB1YmxpYyBrZXlcbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2FrZXlsZXNzLWNvbW11bml0eS9ha2V5bGVzcy8xLjExLjIvZG9jcy9yZXNvdXJjZXMvcHJvZHVjZXJfbW9uZ28jbW9uZ29kYl9hdGxhc19hcGlfcHVibGljX2tleSBQcm9kdWNlck1vbmdvI21vbmdvZGJfYXRsYXNfYXBpX3B1YmxpY19rZXl9XG4gICovXG4gIHJlYWRvbmx5IG1vbmdvZGJBdGxhc0FwaVB1YmxpY0tleT86IHN0cmluZztcbiAgLyoqXG4gICogTW9uZ29EQiBBdGxhcyBwcm9qZWN0IElEXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfYXRsYXNfcHJvamVjdF9pZCBQcm9kdWNlck1vbmdvI21vbmdvZGJfYXRsYXNfcHJvamVjdF9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgbW9uZ29kYkF0bGFzUHJvamVjdElkPzogc3RyaW5nO1xuICAvKipcbiAgKiBNb25nb0RCIHNlcnZlciBkZWZhdWx0IGF1dGhlbnRpY2F0aW9uIGRhdGFiYXNlXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfZGVmYXVsdF9hdXRoX2RiIFByb2R1Y2VyTW9uZ28jbW9uZ29kYl9kZWZhdWx0X2F1dGhfZGJ9XG4gICovXG4gIHJlYWRvbmx5IG1vbmdvZGJEZWZhdWx0QXV0aERiPzogc3RyaW5nO1xuICAvKipcbiAgKiBob3N0OnBvcnQgKGUuZy4gbXkubW9uZ28uZGI6MjcwMTcpXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfaG9zdF9wb3J0IFByb2R1Y2VyTW9uZ28jbW9uZ29kYl9ob3N0X3BvcnR9XG4gICovXG4gIHJlYWRvbmx5IG1vbmdvZGJIb3N0UG9ydD86IHN0cmluZztcbiAgLyoqXG4gICogTW9uZ29EQiBuYW1lXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfbmFtZSBQcm9kdWNlck1vbmdvI21vbmdvZGJfbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgbW9uZ29kYk5hbWU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE1vbmdvREIgc2VydmVyIHBhc3N3b3JkXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfcGFzc3dvcmQgUHJvZHVjZXJNb25nbyNtb25nb2RiX3Bhc3N3b3JkfVxuICAqL1xuICByZWFkb25seSBtb25nb2RiUGFzc3dvcmQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE1vbmdvREIgcm9sZXMgKGUuZy4gTW9uZ29EQjpbe3JvbGU6cmVhZFdyaXRlLCBkYjogc2FsZXN9XSwgTW9uZ29EQiBBdGxhczpbe3JvbGVOYW1lIDogcmVhZFdyaXRlLCBkYXRhYmFzZU5hbWU6IHNhbGVzfV0pXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfcm9sZXMgUHJvZHVjZXJNb25nbyNtb25nb2RiX3JvbGVzfVxuICAqL1xuICByZWFkb25seSBtb25nb2RiUm9sZXM/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE1vbmdvREIgc2VydmVyIFVSSSAoZS5nLiBtb25nb2RiOi8vdXNlcjpwYXNzd29yZEBteS5tb25nby5kYjoyNzAxNy9hZG1pbj9yZXBsaWNhU2V0PW15U2V0KVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyNtb25nb2RiX3NlcnZlcl91cmkgUHJvZHVjZXJNb25nbyNtb25nb2RiX3NlcnZlcl91cml9XG4gICovXG4gIHJlYWRvbmx5IG1vbmdvZGJTZXJ2ZXJVcmk/OiBzdHJpbmc7XG4gIC8qKlxuICAqIE1vbmdvREIgc2VydmVyIFVSSSBvcHRpb25zIChlLmcuIHJlcGxpY2FTZXQ9bXlTZXQmYXV0aFNvdXJjZT1hdXRoREIpXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI21vbmdvZGJfdXJpX29wdGlvbnMgUHJvZHVjZXJNb25nbyNtb25nb2RiX3VyaV9vcHRpb25zfVxuICAqL1xuICByZWFkb25seSBtb25nb2RiVXJpT3B0aW9ucz86IHN0cmluZztcbiAgLyoqXG4gICogTW9uZ29EQiBzZXJ2ZXIgdXNlcm5hbWVcbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2FrZXlsZXNzLWNvbW11bml0eS9ha2V5bGVzcy8xLjExLjIvZG9jcy9yZXNvdXJjZXMvcHJvZHVjZXJfbW9uZ28jbW9uZ29kYl91c2VybmFtZSBQcm9kdWNlck1vbmdvI21vbmdvZGJfdXNlcm5hbWV9XG4gICovXG4gIHJlYWRvbmx5IG1vbmdvZGJVc2VybmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogUHJvZHVjZXIgbmFtZVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyNuYW1lIFByb2R1Y2VyTW9uZ28jbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAvKipcbiAgKiBFbmNyeXB0IHByb2R1Y2VyIHdpdGggZm9sbG93aW5nIGtleVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyNwcm9kdWNlcl9lbmNyeXB0aW9uX2tleV9uYW1lIFByb2R1Y2VyTW9uZ28jcHJvZHVjZXJfZW5jcnlwdGlvbl9rZXlfbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgcHJvZHVjZXJFbmNyeXB0aW9uS2V5TmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogUGF0aCB0byB0aGUgU1NIIENlcnRpZmljYXRlIElzc3VlciBmb3IgeW91ciBBa2V5bGVzcyBCYXN0aW9uXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI3NlY3VyZV9hY2Nlc3NfYmFzdGlvbl9pc3N1ZXIgUHJvZHVjZXJNb25nbyNzZWN1cmVfYWNjZXNzX2Jhc3Rpb25faXNzdWVyfVxuICAqL1xuICByZWFkb25seSBzZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVyPzogc3RyaW5nO1xuICAvKipcbiAgKiBFbmFibGUgV2ViIFNlY3VyZSBSZW1vdGUgQWNjZXNzIFxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyNzZWN1cmVfYWNjZXNzX2RiX25hbWUgUHJvZHVjZXJNb25nbyNzZWN1cmVfYWNjZXNzX2RiX25hbWV9XG4gICovXG4gIHJlYWRvbmx5IHNlY3VyZUFjY2Vzc0RiTmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogRW5hYmxlL0Rpc2FibGUgc2VjdXJlIHJlbW90ZSBhY2Nlc3MsIFt0cnVlL2ZhbHNlXVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyNzZWN1cmVfYWNjZXNzX2VuYWJsZSBQcm9kdWNlck1vbmdvI3NlY3VyZV9hY2Nlc3NfZW5hYmxlfVxuICAqL1xuICByZWFkb25seSBzZWN1cmVBY2Nlc3NFbmFibGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRhcmdldCBEQiBzZXJ2ZXJzIGZvciBjb25uZWN0aW9ucy4sIEZvciBtdWx0aXBsZSB2YWx1ZXMgcmVwZWF0IHRoaXMgZmxhZy5cbiAgKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2FrZXlsZXNzLWNvbW11bml0eS9ha2V5bGVzcy8xLjExLjIvZG9jcy9yZXNvdXJjZXMvcHJvZHVjZXJfbW9uZ28jc2VjdXJlX2FjY2Vzc19ob3N0IFByb2R1Y2VyTW9uZ28jc2VjdXJlX2FjY2Vzc19ob3N0fVxuICAqL1xuICByZWFkb25seSBzZWN1cmVBY2Nlc3NIb3N0Pzogc3RyaW5nW107XG4gIC8qKlxuICAqIEVuYWJsZSBXZWIgU2VjdXJlIFJlbW90ZSBBY2Nlc3MgXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI3NlY3VyZV9hY2Nlc3Nfd2ViIFByb2R1Y2VyTW9uZ28jc2VjdXJlX2FjY2Vzc193ZWJ9XG4gICovXG4gIHJlYWRvbmx5IHNlY3VyZUFjY2Vzc1dlYj86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogTGlzdCBvZiB0aGUgdGFncyBhdHRhY2hlZCB0byB0aGlzIHNlY3JldC4gVG8gc3BlY2lmeSBtdWx0aXBsZSB0YWdzIHVzZSBhcmd1bWVudCBtdWx0aXBsZSB0aW1lczogLXQgVGFnMSAtdCBUYWcyXG4gICpcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvI3RhZ3MgUHJvZHVjZXJNb25nbyN0YWdzfVxuICAqL1xuICByZWFkb25seSB0YWdzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIE5hbWUgb2YgZXhpc3RpbmcgdGFyZ2V0IHRvIHVzZSBpbiBwcm9kdWNlciBjcmVhdGlvblxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyN0YXJnZXRfbmFtZSBQcm9kdWNlck1vbmdvI3RhcmdldF9uYW1lfVxuICAqL1xuICByZWFkb25seSB0YXJnZXROYW1lPzogc3RyaW5nO1xuICAvKipcbiAgKiBVc2VyIFRUTCAoZS5nLiA2MHMsIDYwbSwgNjBoKVxuICAqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyN1c2VyX3R0bCBQcm9kdWNlck1vbmdvI3VzZXJfdHRsfVxuICAqL1xuICByZWFkb25seSB1c2VyVHRsPzogc3RyaW5nO1xufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3JlZ2lzdHJ5LnRlcnJhZm9ybS5pby9wcm92aWRlcnMvYWtleWxlc3MtY29tbXVuaXR5L2FrZXlsZXNzLzEuMTEuMi9kb2NzL3Jlc291cmNlcy9wcm9kdWNlcl9tb25nbyBha2V5bGVzc19wcm9kdWNlcl9tb25nb31cbiovXG5leHBvcnQgY2xhc3MgUHJvZHVjZXJNb25nbyBleHRlbmRzIGNka3RmLlRlcnJhZm9ybVJlc291cmNlIHtcblxuICAvLyA9PT09PT09PT09PT09PT09PVxuICAvLyBTVEFUSUMgUFJPUEVSVElFU1xuICAvLyA9PT09PT09PT09PT09PT09PVxuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IHRmUmVzb3VyY2VUeXBlID0gXCJha2V5bGVzc19wcm9kdWNlcl9tb25nb1wiO1xuXG4gIC8vID09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBNZXRob2RzXG4gIC8vID09PT09PT09PT09PT09XG4gIC8qKlxuICAqIEdlbmVyYXRlcyBDREtURiBjb2RlIGZvciBpbXBvcnRpbmcgYSBQcm9kdWNlck1vbmdvIHJlc291cmNlIHVwb24gcnVubmluZyBcImNka3RmIHBsYW4gPHN0YWNrLW5hbWU+XCJcbiAgKiBAcGFyYW0gc2NvcGUgVGhlIHNjb3BlIGluIHdoaWNoIHRvIGRlZmluZSB0aGlzIGNvbnN0cnVjdFxuICAqIEBwYXJhbSBpbXBvcnRUb0lkIFRoZSBjb25zdHJ1Y3QgaWQgdXNlZCBpbiB0aGUgZ2VuZXJhdGVkIGNvbmZpZyBmb3IgdGhlIFByb2R1Y2VyTW9uZ28gdG8gaW1wb3J0XG4gICogQHBhcmFtIGltcG9ydEZyb21JZCBUaGUgaWQgb2YgdGhlIGV4aXN0aW5nIFByb2R1Y2VyTW9uZ28gdGhhdCBzaG91bGQgYmUgaW1wb3J0ZWQuIFJlZmVyIHRvIHRoZSB7QGxpbmsgaHR0cHM6Ly9yZWdpc3RyeS50ZXJyYWZvcm0uaW8vcHJvdmlkZXJzL2FrZXlsZXNzLWNvbW11bml0eS9ha2V5bGVzcy8xLjExLjIvZG9jcy9yZXNvdXJjZXMvcHJvZHVjZXJfbW9uZ28jaW1wb3J0IGltcG9ydCBzZWN0aW9ufSBpbiB0aGUgZG9jdW1lbnRhdGlvbiBvZiB0aGlzIHJlc291cmNlIGZvciB0aGUgaWQgdG8gdXNlXG4gICogQHBhcmFtIHByb3ZpZGVyPyBPcHRpb25hbCBpbnN0YW5jZSBvZiB0aGUgcHJvdmlkZXIgd2hlcmUgdGhlIFByb2R1Y2VyTW9uZ28gdG8gaW1wb3J0IGlzIGZvdW5kXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgZ2VuZXJhdGVDb25maWdGb3JJbXBvcnQoc2NvcGU6IENvbnN0cnVjdCwgaW1wb3J0VG9JZDogc3RyaW5nLCBpbXBvcnRGcm9tSWQ6IHN0cmluZywgcHJvdmlkZXI/OiBjZGt0Zi5UZXJyYWZvcm1Qcm92aWRlcikge1xuICAgICAgICByZXR1cm4gbmV3IGNka3RmLkltcG9ydGFibGVSZXNvdXJjZShzY29wZSwgaW1wb3J0VG9JZCwgeyB0ZXJyYWZvcm1SZXNvdXJjZVR5cGU6IFwiYWtleWxlc3NfcHJvZHVjZXJfbW9uZ29cIiwgaW1wb3J0SWQ6IGltcG9ydEZyb21JZCwgcHJvdmlkZXIgfSk7XG4gICAgICB9XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vcmVnaXN0cnkudGVycmFmb3JtLmlvL3Byb3ZpZGVycy9ha2V5bGVzcy1jb21tdW5pdHkvYWtleWxlc3MvMS4xMS4yL2RvY3MvcmVzb3VyY2VzL3Byb2R1Y2VyX21vbmdvIGFrZXlsZXNzX3Byb2R1Y2VyX21vbmdvfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBQcm9kdWNlck1vbmdvQ29uZmlnXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IFByb2R1Y2VyTW9uZ29Db25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2FrZXlsZXNzX3Byb2R1Y2VyX21vbmdvJyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2FrZXlsZXNzJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uOiAnMS4xMS4yJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDEuMTEuMidcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZSxcbiAgICAgIHByb3Zpc2lvbmVyczogY29uZmlnLnByb3Zpc2lvbmVycyxcbiAgICAgIGNvbm5lY3Rpb246IGNvbmZpZy5jb25uZWN0aW9uLFxuICAgICAgZm9yRWFjaDogY29uZmlnLmZvckVhY2hcbiAgICB9KTtcbiAgICB0aGlzLl9pZCA9IGNvbmZpZy5pZDtcbiAgICB0aGlzLl9tb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5ID0gY29uZmlnLm1vbmdvZGJBdGxhc0FwaVByaXZhdGVLZXk7XG4gICAgdGhpcy5fbW9uZ29kYkF0bGFzQXBpUHVibGljS2V5ID0gY29uZmlnLm1vbmdvZGJBdGxhc0FwaVB1YmxpY0tleTtcbiAgICB0aGlzLl9tb25nb2RiQXRsYXNQcm9qZWN0SWQgPSBjb25maWcubW9uZ29kYkF0bGFzUHJvamVjdElkO1xuICAgIHRoaXMuX21vbmdvZGJEZWZhdWx0QXV0aERiID0gY29uZmlnLm1vbmdvZGJEZWZhdWx0QXV0aERiO1xuICAgIHRoaXMuX21vbmdvZGJIb3N0UG9ydCA9IGNvbmZpZy5tb25nb2RiSG9zdFBvcnQ7XG4gICAgdGhpcy5fbW9uZ29kYk5hbWUgPSBjb25maWcubW9uZ29kYk5hbWU7XG4gICAgdGhpcy5fbW9uZ29kYlBhc3N3b3JkID0gY29uZmlnLm1vbmdvZGJQYXNzd29yZDtcbiAgICB0aGlzLl9tb25nb2RiUm9sZXMgPSBjb25maWcubW9uZ29kYlJvbGVzO1xuICAgIHRoaXMuX21vbmdvZGJTZXJ2ZXJVcmkgPSBjb25maWcubW9uZ29kYlNlcnZlclVyaTtcbiAgICB0aGlzLl9tb25nb2RiVXJpT3B0aW9ucyA9IGNvbmZpZy5tb25nb2RiVXJpT3B0aW9ucztcbiAgICB0aGlzLl9tb25nb2RiVXNlcm5hbWUgPSBjb25maWcubW9uZ29kYlVzZXJuYW1lO1xuICAgIHRoaXMuX25hbWUgPSBjb25maWcubmFtZTtcbiAgICB0aGlzLl9wcm9kdWNlckVuY3J5cHRpb25LZXlOYW1lID0gY29uZmlnLnByb2R1Y2VyRW5jcnlwdGlvbktleU5hbWU7XG4gICAgdGhpcy5fc2VjdXJlQWNjZXNzQmFzdGlvbklzc3VlciA9IGNvbmZpZy5zZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVyO1xuICAgIHRoaXMuX3NlY3VyZUFjY2Vzc0RiTmFtZSA9IGNvbmZpZy5zZWN1cmVBY2Nlc3NEYk5hbWU7XG4gICAgdGhpcy5fc2VjdXJlQWNjZXNzRW5hYmxlID0gY29uZmlnLnNlY3VyZUFjY2Vzc0VuYWJsZTtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NIb3N0ID0gY29uZmlnLnNlY3VyZUFjY2Vzc0hvc3Q7XG4gICAgdGhpcy5fc2VjdXJlQWNjZXNzV2ViID0gY29uZmlnLnNlY3VyZUFjY2Vzc1dlYjtcbiAgICB0aGlzLl90YWdzID0gY29uZmlnLnRhZ3M7XG4gICAgdGhpcy5fdGFyZ2V0TmFtZSA9IGNvbmZpZy50YXJnZXROYW1lO1xuICAgIHRoaXMuX3VzZXJUdGwgPSBjb25maWcudXNlclR0bDtcbiAgfVxuXG4gIC8vID09PT09PT09PT1cbiAgLy8gQVRUUklCVVRFU1xuICAvLyA9PT09PT09PT09XG5cbiAgLy8gaWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9pZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgaWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdpZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgaWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2lkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0SWQoKSB7XG4gICAgdGhpcy5faWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2lkO1xuICB9XG5cbiAgLy8gbW9uZ29kYl9hdGxhc19hcGlfcHJpdmF0ZV9rZXkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbW9uZ29kYkF0bGFzQXBpUHJpdmF0ZUtleT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYkF0bGFzQXBpUHJpdmF0ZUtleSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21vbmdvZGJfYXRsYXNfYXBpX3ByaXZhdGVfa2V5Jyk7XG4gIH1cbiAgcHVibGljIHNldCBtb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TW9uZ29kYkF0bGFzQXBpUHJpdmF0ZUtleSgpIHtcbiAgICB0aGlzLl9tb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21vbmdvZGJBdGxhc0FwaVByaXZhdGVLZXk7XG4gIH1cblxuICAvLyBtb25nb2RiX2F0bGFzX2FwaV9wdWJsaWNfa2V5IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21vbmdvZGJBdGxhc0FwaVB1YmxpY0tleT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYkF0bGFzQXBpUHVibGljS2V5KCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbW9uZ29kYl9hdGxhc19hcGlfcHVibGljX2tleScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbW9uZ29kYkF0bGFzQXBpUHVibGljS2V5KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tb25nb2RiQXRsYXNBcGlQdWJsaWNLZXkgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNb25nb2RiQXRsYXNBcGlQdWJsaWNLZXkoKSB7XG4gICAgdGhpcy5fbW9uZ29kYkF0bGFzQXBpUHVibGljS2V5ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtb25nb2RiQXRsYXNBcGlQdWJsaWNLZXlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbW9uZ29kYkF0bGFzQXBpUHVibGljS2V5O1xuICB9XG5cbiAgLy8gbW9uZ29kYl9hdGxhc19wcm9qZWN0X2lkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21vbmdvZGJBdGxhc1Byb2plY3RJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYkF0bGFzUHJvamVjdElkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbW9uZ29kYl9hdGxhc19wcm9qZWN0X2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBtb25nb2RiQXRsYXNQcm9qZWN0SWQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX21vbmdvZGJBdGxhc1Byb2plY3RJZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1vbmdvZGJBdGxhc1Byb2plY3RJZCgpIHtcbiAgICB0aGlzLl9tb25nb2RiQXRsYXNQcm9qZWN0SWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1vbmdvZGJBdGxhc1Byb2plY3RJZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tb25nb2RiQXRsYXNQcm9qZWN0SWQ7XG4gIH1cblxuICAvLyBtb25nb2RiX2RlZmF1bHRfYXV0aF9kYiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tb25nb2RiRGVmYXVsdEF1dGhEYj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYkRlZmF1bHRBdXRoRGIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtb25nb2RiX2RlZmF1bHRfYXV0aF9kYicpO1xuICB9XG4gIHB1YmxpYyBzZXQgbW9uZ29kYkRlZmF1bHRBdXRoRGIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX21vbmdvZGJEZWZhdWx0QXV0aERiID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TW9uZ29kYkRlZmF1bHRBdXRoRGIoKSB7XG4gICAgdGhpcy5fbW9uZ29kYkRlZmF1bHRBdXRoRGIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1vbmdvZGJEZWZhdWx0QXV0aERiSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21vbmdvZGJEZWZhdWx0QXV0aERiO1xuICB9XG5cbiAgLy8gbW9uZ29kYl9ob3N0X3BvcnQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbW9uZ29kYkhvc3RQb3J0Pzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtb25nb2RiSG9zdFBvcnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtb25nb2RiX2hvc3RfcG9ydCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbW9uZ29kYkhvc3RQb3J0KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tb25nb2RiSG9zdFBvcnQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNb25nb2RiSG9zdFBvcnQoKSB7XG4gICAgdGhpcy5fbW9uZ29kYkhvc3RQb3J0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtb25nb2RiSG9zdFBvcnRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbW9uZ29kYkhvc3RQb3J0O1xuICB9XG5cbiAgLy8gbW9uZ29kYl9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21vbmdvZGJOYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtb25nb2RiTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21vbmdvZGJfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbW9uZ29kYk5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX21vbmdvZGJOYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TW9uZ29kYk5hbWUoKSB7XG4gICAgdGhpcy5fbW9uZ29kYk5hbWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1vbmdvZGJOYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21vbmdvZGJOYW1lO1xuICB9XG5cbiAgLy8gbW9uZ29kYl9wYXNzd29yZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tb25nb2RiUGFzc3dvcmQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG1vbmdvZGJQYXNzd29yZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21vbmdvZGJfcGFzc3dvcmQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1vbmdvZGJQYXNzd29yZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbW9uZ29kYlBhc3N3b3JkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TW9uZ29kYlBhc3N3b3JkKCkge1xuICAgIHRoaXMuX21vbmdvZGJQYXNzd29yZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbW9uZ29kYlBhc3N3b3JkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21vbmdvZGJQYXNzd29yZDtcbiAgfVxuXG4gIC8vIG1vbmdvZGJfcm9sZXMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbW9uZ29kYlJvbGVzPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtb25nb2RiUm9sZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtb25nb2RiX3JvbGVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBtb25nb2RiUm9sZXModmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX21vbmdvZGJSb2xlcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1vbmdvZGJSb2xlcygpIHtcbiAgICB0aGlzLl9tb25nb2RiUm9sZXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1vbmdvZGJSb2xlc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tb25nb2RiUm9sZXM7XG4gIH1cblxuICAvLyBtb25nb2RiX3NlcnZlcl91cmkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfbW9uZ29kYlNlcnZlclVyaT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYlNlcnZlclVyaSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21vbmdvZGJfc2VydmVyX3VyaScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbW9uZ29kYlNlcnZlclVyaSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbW9uZ29kYlNlcnZlclVyaSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1vbmdvZGJTZXJ2ZXJVcmkoKSB7XG4gICAgdGhpcy5fbW9uZ29kYlNlcnZlclVyaSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbW9uZ29kYlNlcnZlclVyaUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tb25nb2RiU2VydmVyVXJpO1xuICB9XG5cbiAgLy8gbW9uZ29kYl91cmlfb3B0aW9ucyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tb25nb2RiVXJpT3B0aW9ucz86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYlVyaU9wdGlvbnMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtb25nb2RiX3VyaV9vcHRpb25zJyk7XG4gIH1cbiAgcHVibGljIHNldCBtb25nb2RiVXJpT3B0aW9ucyh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbW9uZ29kYlVyaU9wdGlvbnMgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNb25nb2RiVXJpT3B0aW9ucygpIHtcbiAgICB0aGlzLl9tb25nb2RiVXJpT3B0aW9ucyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbW9uZ29kYlVyaU9wdGlvbnNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbW9uZ29kYlVyaU9wdGlvbnM7XG4gIH1cblxuICAvLyBtb25nb2RiX3VzZXJuYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21vbmdvZGJVc2VybmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9uZ29kYlVzZXJuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbW9uZ29kYl91c2VybmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbW9uZ29kYlVzZXJuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tb25nb2RiVXNlcm5hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNb25nb2RiVXNlcm5hbWUoKSB7XG4gICAgdGhpcy5fbW9uZ29kYlVzZXJuYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtb25nb2RiVXNlcm5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbW9uZ29kYlVzZXJuYW1lO1xuICB9XG5cbiAgLy8gbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogdHJ1ZVxuICBwcml2YXRlIF9uYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbmFtZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBuYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX25hbWU7XG4gIH1cblxuICAvLyBwcm9kdWNlcl9lbmNyeXB0aW9uX2tleV9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Byb2R1Y2VyRW5jcnlwdGlvbktleU5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHByb2R1Y2VyRW5jcnlwdGlvbktleU5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwcm9kdWNlcl9lbmNyeXB0aW9uX2tleV9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBwcm9kdWNlckVuY3J5cHRpb25LZXlOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wcm9kdWNlckVuY3J5cHRpb25LZXlOYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UHJvZHVjZXJFbmNyeXB0aW9uS2V5TmFtZSgpIHtcbiAgICB0aGlzLl9wcm9kdWNlckVuY3J5cHRpb25LZXlOYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwcm9kdWNlckVuY3J5cHRpb25LZXlOYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Byb2R1Y2VyRW5jcnlwdGlvbktleU5hbWU7XG4gIH1cblxuICAvLyBzZWN1cmVfYWNjZXNzX2Jhc3Rpb25faXNzdWVyIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NlY3VyZUFjY2Vzc0Jhc3Rpb25Jc3N1ZXI/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNlY3VyZUFjY2Vzc0Jhc3Rpb25Jc3N1ZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzZWN1cmVfYWNjZXNzX2Jhc3Rpb25faXNzdWVyJyk7XG4gIH1cbiAgcHVibGljIHNldCBzZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVyKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2VjdXJlQWNjZXNzQmFzdGlvbklzc3VlcigpIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVyID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NlY3VyZUFjY2Vzc0Jhc3Rpb25Jc3N1ZXI7XG4gIH1cblxuICAvLyBzZWN1cmVfYWNjZXNzX2RiX25hbWUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zZWN1cmVBY2Nlc3NEYk5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHNlY3VyZUFjY2Vzc0RiTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3NlY3VyZV9hY2Nlc3NfZGJfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VjdXJlQWNjZXNzRGJOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NEYk5hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTZWN1cmVBY2Nlc3NEYk5hbWUoKSB7XG4gICAgdGhpcy5fc2VjdXJlQWNjZXNzRGJOYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZWN1cmVBY2Nlc3NEYk5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2VjdXJlQWNjZXNzRGJOYW1lO1xuICB9XG5cbiAgLy8gc2VjdXJlX2FjY2Vzc19lbmFibGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc2VjdXJlQWNjZXNzRW5hYmxlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzZWN1cmVBY2Nlc3NFbmFibGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzZWN1cmVfYWNjZXNzX2VuYWJsZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VjdXJlQWNjZXNzRW5hYmxlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NFbmFibGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTZWN1cmVBY2Nlc3NFbmFibGUoKSB7XG4gICAgdGhpcy5fc2VjdXJlQWNjZXNzRW5hYmxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZWN1cmVBY2Nlc3NFbmFibGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2VjdXJlQWNjZXNzRW5hYmxlO1xuICB9XG5cbiAgLy8gc2VjdXJlX2FjY2Vzc19ob3N0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3NlY3VyZUFjY2Vzc0hvc3Q/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgc2VjdXJlQWNjZXNzSG9zdCgpIHtcbiAgICByZXR1cm4gY2RrdGYuRm4udG9saXN0KHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnc2VjdXJlX2FjY2Vzc19ob3N0JykpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VjdXJlQWNjZXNzSG9zdCh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NIb3N0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2VjdXJlQWNjZXNzSG9zdCgpIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NIb3N0ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZWN1cmVBY2Nlc3NIb3N0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NlY3VyZUFjY2Vzc0hvc3Q7XG4gIH1cblxuICAvLyBzZWN1cmVfYWNjZXNzX3dlYiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zZWN1cmVBY2Nlc3NXZWI/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IHNlY3VyZUFjY2Vzc1dlYigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdzZWN1cmVfYWNjZXNzX3dlYicpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2VjdXJlQWNjZXNzV2ViKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9zZWN1cmVBY2Nlc3NXZWIgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRTZWN1cmVBY2Nlc3NXZWIoKSB7XG4gICAgdGhpcy5fc2VjdXJlQWNjZXNzV2ViID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzZWN1cmVBY2Nlc3NXZWJJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fc2VjdXJlQWNjZXNzV2ViO1xuICB9XG5cbiAgLy8gdGFncyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90YWdzPzogc3RyaW5nW107IFxuICBwdWJsaWMgZ2V0IHRhZ3MoKSB7XG4gICAgcmV0dXJuIGNka3RmLkZuLnRvbGlzdCh0aGlzLmdldExpc3RBdHRyaWJ1dGUoJ3RhZ3MnKSk7XG4gIH1cbiAgcHVibGljIHNldCB0YWdzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX3RhZ3MgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUYWdzKCkge1xuICAgIHRoaXMuX3RhZ3MgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRhZ3NJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGFncztcbiAgfVxuXG4gIC8vIHRhcmdldF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RhcmdldE5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHRhcmdldE5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd0YXJnZXRfbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGFyZ2V0TmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdGFyZ2V0TmFtZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRhcmdldE5hbWUoKSB7XG4gICAgdGhpcy5fdGFyZ2V0TmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGFyZ2V0TmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90YXJnZXROYW1lO1xuICB9XG5cbiAgLy8gdXNlcl90dGwgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXNlclR0bD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdXNlclR0bCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VzZXJfdHRsJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2VyVHRsKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91c2VyVHRsID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXNlclR0bCgpIHtcbiAgICB0aGlzLl91c2VyVHRsID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2VyVHRsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VzZXJUdGw7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGlkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICBtb25nb2RiX2F0bGFzX2FwaV9wcml2YXRlX2tleTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbW9uZ29kYkF0bGFzQXBpUHJpdmF0ZUtleSksXG4gICAgICBtb25nb2RiX2F0bGFzX2FwaV9wdWJsaWNfa2V5OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiQXRsYXNBcGlQdWJsaWNLZXkpLFxuICAgICAgbW9uZ29kYl9hdGxhc19wcm9qZWN0X2lkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiQXRsYXNQcm9qZWN0SWQpLFxuICAgICAgbW9uZ29kYl9kZWZhdWx0X2F1dGhfZGI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX21vbmdvZGJEZWZhdWx0QXV0aERiKSxcbiAgICAgIG1vbmdvZGJfaG9zdF9wb3J0OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiSG9zdFBvcnQpLFxuICAgICAgbW9uZ29kYl9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiTmFtZSksXG4gICAgICBtb25nb2RiX3Bhc3N3b3JkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiUGFzc3dvcmQpLFxuICAgICAgbW9uZ29kYl9yb2xlczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbW9uZ29kYlJvbGVzKSxcbiAgICAgIG1vbmdvZGJfc2VydmVyX3VyaTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbW9uZ29kYlNlcnZlclVyaSksXG4gICAgICBtb25nb2RiX3VyaV9vcHRpb25zOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiVXJpT3B0aW9ucyksXG4gICAgICBtb25nb2RiX3VzZXJuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9tb25nb2RiVXNlcm5hbWUpLFxuICAgICAgbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICBwcm9kdWNlcl9lbmNyeXB0aW9uX2tleV9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9wcm9kdWNlckVuY3J5cHRpb25LZXlOYW1lKSxcbiAgICAgIHNlY3VyZV9hY2Nlc3NfYmFzdGlvbl9pc3N1ZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3NlY3VyZUFjY2Vzc0Jhc3Rpb25Jc3N1ZXIpLFxuICAgICAgc2VjdXJlX2FjY2Vzc19kYl9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zZWN1cmVBY2Nlc3NEYk5hbWUpLFxuICAgICAgc2VjdXJlX2FjY2Vzc19lbmFibGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3NlY3VyZUFjY2Vzc0VuYWJsZSksXG4gICAgICBzZWN1cmVfYWNjZXNzX2hvc3Q6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKSh0aGlzLl9zZWN1cmVBY2Nlc3NIb3N0KSxcbiAgICAgIHNlY3VyZV9hY2Nlc3Nfd2ViOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fc2VjdXJlQWNjZXNzV2ViKSxcbiAgICAgIHRhZ3M6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0sIGZhbHNlKSh0aGlzLl90YWdzKSxcbiAgICAgIHRhcmdldF9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90YXJnZXROYW1lKSxcbiAgICAgIHVzZXJfdHRsOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl91c2VyVHRsKSxcbiAgICB9O1xuICB9XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVIY2xBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICBjb25zdCBhdHRycyA9IHtcbiAgICAgIGlkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9pZCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIG1vbmdvZGJfYXRsYXNfYXBpX3ByaXZhdGVfa2V5OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9tb25nb2RiQXRsYXNBcGlQcml2YXRlS2V5KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbW9uZ29kYl9hdGxhc19hcGlfcHVibGljX2tleToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbW9uZ29kYkF0bGFzQXBpUHVibGljS2V5KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbW9uZ29kYl9hdGxhc19wcm9qZWN0X2lkOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9tb25nb2RiQXRsYXNQcm9qZWN0SWQpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBtb25nb2RiX2RlZmF1bHRfYXV0aF9kYjoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbW9uZ29kYkRlZmF1bHRBdXRoRGIpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBtb25nb2RiX2hvc3RfcG9ydDoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbW9uZ29kYkhvc3RQb3J0KSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbW9uZ29kYl9uYW1lOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9tb25nb2RiTmFtZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIG1vbmdvZGJfcGFzc3dvcmQ6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX21vbmdvZGJQYXNzd29yZCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIG1vbmdvZGJfcm9sZXM6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX21vbmdvZGJSb2xlcyksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIG1vbmdvZGJfc2VydmVyX3VyaToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbW9uZ29kYlNlcnZlclVyaSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIG1vbmdvZGJfdXJpX29wdGlvbnM6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX21vbmdvZGJVcmlPcHRpb25zKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbW9uZ29kYl91c2VybmFtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbW9uZ29kYlVzZXJuYW1lKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgbmFtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIHByb2R1Y2VyX2VuY3J5cHRpb25fa2V5X25hbWU6IHtcbiAgICAgICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtKHRoaXMuX3Byb2R1Y2VyRW5jcnlwdGlvbktleU5hbWUpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBzZWN1cmVfYWNjZXNzX2Jhc3Rpb25faXNzdWVyOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9zZWN1cmVBY2Nlc3NCYXN0aW9uSXNzdWVyKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgc2VjdXJlX2FjY2Vzc19kYl9uYW1lOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl9zZWN1cmVBY2Nlc3NEYk5hbWUpLFxuICAgICAgICBpc0Jsb2NrOiBmYWxzZSxcbiAgICAgICAgdHlwZTogXCJzaW1wbGVcIixcbiAgICAgICAgc3RvcmFnZUNsYXNzVHlwZTogXCJzdHJpbmdcIixcbiAgICAgIH0sXG4gICAgICBzZWN1cmVfYWNjZXNzX2VuYWJsZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fc2VjdXJlQWNjZXNzRW5hYmxlKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgICAgc2VjdXJlX2FjY2Vzc19ob3N0OiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5saXN0TWFwcGVySGNsKGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtLCBmYWxzZSkodGhpcy5fc2VjdXJlQWNjZXNzSG9zdCksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNldFwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ0xpc3RcIixcbiAgICAgIH0sXG4gICAgICBzZWN1cmVfYWNjZXNzX3dlYjoge1xuICAgICAgICB2YWx1ZTogY2RrdGYuYm9vbGVhblRvSGNsVGVycmFmb3JtKHRoaXMuX3NlY3VyZUFjY2Vzc1dlYiksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcImJvb2xlYW5cIixcbiAgICAgIH0sXG4gICAgICB0YWdzOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5saXN0TWFwcGVySGNsKGNka3RmLnN0cmluZ1RvSGNsVGVycmFmb3JtLCBmYWxzZSkodGhpcy5fdGFncyksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNldFwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ0xpc3RcIixcbiAgICAgIH0sXG4gICAgICB0YXJnZXRfbmFtZToge1xuICAgICAgICB2YWx1ZTogY2RrdGYuc3RyaW5nVG9IY2xUZXJyYWZvcm0odGhpcy5fdGFyZ2V0TmFtZSksXG4gICAgICAgIGlzQmxvY2s6IGZhbHNlLFxuICAgICAgICB0eXBlOiBcInNpbXBsZVwiLFxuICAgICAgICBzdG9yYWdlQ2xhc3NUeXBlOiBcInN0cmluZ1wiLFxuICAgICAgfSxcbiAgICAgIHVzZXJfdHRsOiB7XG4gICAgICAgIHZhbHVlOiBjZGt0Zi5zdHJpbmdUb0hjbFRlcnJhZm9ybSh0aGlzLl91c2VyVHRsKSxcbiAgICAgICAgaXNCbG9jazogZmFsc2UsXG4gICAgICAgIHR5cGU6IFwic2ltcGxlXCIsXG4gICAgICAgIHN0b3JhZ2VDbGFzc1R5cGU6IFwic3RyaW5nXCIsXG4gICAgICB9LFxuICAgIH07XG5cbiAgICAvLyByZW1vdmUgdW5kZWZpbmVkIGF0dHJpYnV0ZXNcbiAgICByZXR1cm4gT2JqZWN0LmZyb21FbnRyaWVzKE9iamVjdC5lbnRyaWVzKGF0dHJzKS5maWx0ZXIoKFtfLCB2YWx1ZV0pID0+IHZhbHVlICE9PSB1bmRlZmluZWQgJiYgdmFsdWUudmFsdWUgIT09IHVuZGVmaW5lZCApKVxuICB9XG59XG4iXX0=