import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerGithubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Github application id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#github_app_id ProducerGithub#github_app_id}
    */
    readonly githubAppId?: number;
    /**
    * Github application private key (base64 encoded key)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#github_app_private_key ProducerGithub#github_app_private_key}
    */
    readonly githubAppPrivateKey?: string;
    /**
    * Github base url
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#github_base_url ProducerGithub#github_base_url}
    */
    readonly githubBaseUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#id ProducerGithub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Github application installation id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#installation_id ProducerGithub#installation_id}
    */
    readonly installationId?: number;
    /**
    * Optional, instead of installation id, set a GitHub repository '<owner>/<repo-name>'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#installation_repository ProducerGithub#installation_repository}
    */
    readonly installationRepository?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#name ProducerGithub#name}
    */
    readonly name: string;
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#target_name ProducerGithub#target_name}
    */
    readonly targetName?: string;
    /**
    * Tokens' allowed permissions. By default use installation allowed permissions. Input format: key=value pairs or JSON strings, e.g - -p contents=read -p issues=write or -p '{content:read}'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#token_permissions ProducerGithub#token_permissions}
    */
    readonly tokenPermissions?: string[];
    /**
    * Tokens' allowed repositories. By default use installation allowed repositories. To specify multiple repositories use argument multiple times: -r RepoName1 -r RepoName2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#token_repositories ProducerGithub#token_repositories}
    */
    readonly tokenRepositories?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github akeyless_producer_github}
*/
export declare class ProducerGithub extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_github";
    /**
    * Generates CDKTF code for importing a ProducerGithub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerGithub to import
    * @param importFromId The id of the existing ProducerGithub that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerGithub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_github akeyless_producer_github} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerGithubConfig
    */
    constructor(scope: Construct, id: string, config: ProducerGithubConfig);
    private _githubAppId?;
    get githubAppId(): number;
    set githubAppId(value: number);
    resetGithubAppId(): void;
    get githubAppIdInput(): number | undefined;
    private _githubAppPrivateKey?;
    get githubAppPrivateKey(): string;
    set githubAppPrivateKey(value: string);
    resetGithubAppPrivateKey(): void;
    get githubAppPrivateKeyInput(): string | undefined;
    private _githubBaseUrl?;
    get githubBaseUrl(): string;
    set githubBaseUrl(value: string);
    resetGithubBaseUrl(): void;
    get githubBaseUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _installationId?;
    get installationId(): number;
    set installationId(value: number);
    resetInstallationId(): void;
    get installationIdInput(): number | undefined;
    private _installationRepository?;
    get installationRepository(): string;
    set installationRepository(value: string);
    resetInstallationRepository(): void;
    get installationRepositoryInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _tokenPermissions?;
    get tokenPermissions(): string[];
    set tokenPermissions(value: string[]);
    resetTokenPermissions(): void;
    get tokenPermissionsInput(): string[] | undefined;
    private _tokenRepositories?;
    get tokenRepositories(): string[];
    set tokenRepositories(value: string[]);
    resetTokenRepositories(): void;
    get tokenRepositoriesInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
