import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerGcpConfig extends cdktf.TerraformMetaArguments {
    /**
    * Protection from accidental deletion of this item, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#delete_protection ProducerGcp#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Credentials type, options are [token, key]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#gcp_cred_type ProducerGcp#gcp_cred_type}
    */
    readonly gcpCredType?: string;
    /**
    * Base64-encoded service account private key text
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#gcp_key ProducerGcp#gcp_key}
    */
    readonly gcpKey?: string;
    /**
    * Service account key algorithm, e.g. KEY_ALG_RSA_1024
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#gcp_key_algo ProducerGcp#gcp_key_algo}
    */
    readonly gcpKeyAlgo?: string;
    /**
    * GCP service account email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#gcp_sa_email ProducerGcp#gcp_sa_email}
    */
    readonly gcpSaEmail?: string;
    /**
    * Access token scopes list, e.g. scope1,scope2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#gcp_token_scopes ProducerGcp#gcp_token_scopes}
    */
    readonly gcpTokenScopes?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#id ProducerGcp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#name ProducerGcp#name}
    */
    readonly name: string;
    /**
    * Dynamic producer encryption key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#producer_encryption_key_name ProducerGcp#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Role binding definitions in json format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#role_binding ProducerGcp#role_binding}
    */
    readonly roleBinding?: string;
    /**
    * The type of the gcp dynamic secret. Options[fixed, dynamic]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#service_account_type ProducerGcp#service_account_type}
    */
    readonly serviceAccountType?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: --tag Tag1 --tag Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#tags ProducerGcp#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#target_name ProducerGcp#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL (<=60m for access token)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#user_ttl ProducerGcp#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp akeyless_producer_gcp}
*/
export declare class ProducerGcp extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_gcp";
    /**
    * Generates CDKTF code for importing a ProducerGcp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerGcp to import
    * @param importFromId The id of the existing ProducerGcp that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerGcp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_gcp akeyless_producer_gcp} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerGcpConfig
    */
    constructor(scope: Construct, id: string, config: ProducerGcpConfig);
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _gcpCredType?;
    get gcpCredType(): string;
    set gcpCredType(value: string);
    resetGcpCredType(): void;
    get gcpCredTypeInput(): string | undefined;
    private _gcpKey?;
    get gcpKey(): string;
    set gcpKey(value: string);
    resetGcpKey(): void;
    get gcpKeyInput(): string | undefined;
    private _gcpKeyAlgo?;
    get gcpKeyAlgo(): string;
    set gcpKeyAlgo(value: string);
    resetGcpKeyAlgo(): void;
    get gcpKeyAlgoInput(): string | undefined;
    private _gcpSaEmail?;
    get gcpSaEmail(): string;
    set gcpSaEmail(value: string);
    resetGcpSaEmail(): void;
    get gcpSaEmailInput(): string | undefined;
    private _gcpTokenScopes?;
    get gcpTokenScopes(): string;
    set gcpTokenScopes(value: string);
    resetGcpTokenScopes(): void;
    get gcpTokenScopesInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _roleBinding?;
    get roleBinding(): string;
    set roleBinding(value: string);
    resetRoleBinding(): void;
    get roleBindingInput(): string | undefined;
    private _serviceAccountType?;
    get serviceAccountType(): string;
    set serviceAccountType(value: string);
    resetServiceAccountType(): void;
    get serviceAccountTypeInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
