import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerCassandraConfig extends cdktf.TerraformMetaArguments {
    /**
    * Cassandra Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#cassandra_creation_statements ProducerCassandra#cassandra_creation_statements}
    */
    readonly cassandraCreationStatements?: string;
    /**
    * Cassandra hosts names or IP addresses, comma separated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#cassandra_hosts ProducerCassandra#cassandra_hosts}
    */
    readonly cassandraHosts?: string;
    /**
    * Cassandra superuser password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#cassandra_password ProducerCassandra#cassandra_password}
    */
    readonly cassandraPassword?: string;
    /**
    * Cassandra port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#cassandra_port ProducerCassandra#cassandra_port}
    */
    readonly cassandraPort?: string;
    /**
    * Cassandra superuser user name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#cassandra_username ProducerCassandra#cassandra_username}
    */
    readonly cassandraUsername?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#id ProducerCassandra#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#name ProducerCassandra#name}
    */
    readonly name: string;
    /**
    * Dynamic producer encryption key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#producer_encryption_key_name ProducerCassandra#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#tags ProducerCassandra#tags}
    */
    readonly tags?: string[];
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#target_name ProducerCassandra#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL (<=60m for access token)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#user_ttl ProducerCassandra#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra akeyless_producer_cassandra}
*/
export declare class ProducerCassandra extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_cassandra";
    /**
    * Generates CDKTF code for importing a ProducerCassandra resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerCassandra to import
    * @param importFromId The id of the existing ProducerCassandra that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerCassandra to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_cassandra akeyless_producer_cassandra} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerCassandraConfig
    */
    constructor(scope: Construct, id: string, config: ProducerCassandraConfig);
    private _cassandraCreationStatements?;
    get cassandraCreationStatements(): string;
    set cassandraCreationStatements(value: string);
    resetCassandraCreationStatements(): void;
    get cassandraCreationStatementsInput(): string | undefined;
    private _cassandraHosts?;
    get cassandraHosts(): string;
    set cassandraHosts(value: string);
    resetCassandraHosts(): void;
    get cassandraHostsInput(): string | undefined;
    private _cassandraPassword?;
    get cassandraPassword(): string;
    set cassandraPassword(value: string);
    resetCassandraPassword(): void;
    get cassandraPasswordInput(): string | undefined;
    private _cassandraPort?;
    get cassandraPort(): string;
    set cassandraPort(value: string);
    resetCassandraPort(): void;
    get cassandraPortInput(): string | undefined;
    private _cassandraUsername?;
    get cassandraUsername(): string;
    set cassandraUsername(value: string);
    resetCassandraUsername(): void;
    get cassandraUsernameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
