import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerAzureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Azure App Object ID (required if selected programmatic access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#app_obj_id ProducerAzure#app_obj_id}
    */
    readonly appObjId?: string;
    /**
    * Azure Client ID (Application ID)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#azure_client_id ProducerAzure#azure_client_id}
    */
    readonly azureClientId?: string;
    /**
    * Azure AD Client Secret
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#azure_client_secret ProducerAzure#azure_client_secret}
    */
    readonly azureClientSecret?: string;
    /**
    * Azure Tenant ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#azure_tenant_id ProducerAzure#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#id ProducerAzure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#name ProducerAzure#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#producer_encryption_key_name ProducerAzure#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#secure_access_enable ProducerAzure#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#secure_access_url ProducerAzure#secure_access_url}
    */
    readonly secureAccessUrl?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#secure_access_web ProducerAzure#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * Secure browser via Akeyless Web Access Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#secure_access_web_browsing ProducerAzure#secure_access_web_browsing}
    */
    readonly secureAccessWebBrowsing?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: --tag Tag1 --tag Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#tags ProducerAzure#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#target_name ProducerAzure#target_name}
    */
    readonly targetName?: string;
    /**
    * Azure AD User Group Object ID (required if selected Portal access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#user_group_obj_id ProducerAzure#user_group_obj_id}
    */
    readonly userGroupObjId?: string;
    /**
    * Enable Azure AD user portal access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#user_portal_access ProducerAzure#user_portal_access}
    */
    readonly userPortalAccess?: boolean | cdktf.IResolvable;
    /**
    * Azure AD User Principal Name (required if selected Portal access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#user_principal_name ProducerAzure#user_principal_name}
    */
    readonly userPrincipalName?: string;
    /**
    * Enable Azure AD user programmatic access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#user_programmatic_access ProducerAzure#user_programmatic_access}
    */
    readonly userProgrammaticAccess?: boolean | cdktf.IResolvable;
    /**
    * Azure AD User Role Template ID (required if selected Portal access)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#user_role_template_id ProducerAzure#user_role_template_id}
    */
    readonly userRoleTemplateId?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#user_ttl ProducerAzure#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure akeyless_producer_azure}
*/
export declare class ProducerAzure extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_azure";
    /**
    * Generates CDKTF code for importing a ProducerAzure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerAzure to import
    * @param importFromId The id of the existing ProducerAzure that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerAzure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_azure akeyless_producer_azure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerAzureConfig
    */
    constructor(scope: Construct, id: string, config: ProducerAzureConfig);
    private _appObjId?;
    get appObjId(): string;
    set appObjId(value: string);
    resetAppObjId(): void;
    get appObjIdInput(): string | undefined;
    private _azureClientId?;
    get azureClientId(): string;
    set azureClientId(value: string);
    resetAzureClientId(): void;
    get azureClientIdInput(): string | undefined;
    private _azureClientSecret?;
    get azureClientSecret(): string;
    set azureClientSecret(value: string);
    resetAzureClientSecret(): void;
    get azureClientSecretInput(): string | undefined;
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessUrl?;
    get secureAccessUrl(): string;
    set secureAccessUrl(value: string);
    resetSecureAccessUrl(): void;
    get secureAccessUrlInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessWebBrowsing?;
    get secureAccessWebBrowsing(): boolean | cdktf.IResolvable;
    set secureAccessWebBrowsing(value: boolean | cdktf.IResolvable);
    resetSecureAccessWebBrowsing(): void;
    get secureAccessWebBrowsingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userGroupObjId?;
    get userGroupObjId(): string;
    set userGroupObjId(value: string);
    resetUserGroupObjId(): void;
    get userGroupObjIdInput(): string | undefined;
    private _userPortalAccess?;
    get userPortalAccess(): boolean | cdktf.IResolvable;
    set userPortalAccess(value: boolean | cdktf.IResolvable);
    resetUserPortalAccess(): void;
    get userPortalAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _userPrincipalName?;
    get userPrincipalName(): string;
    set userPrincipalName(value: string);
    resetUserPrincipalName(): void;
    get userPrincipalNameInput(): string | undefined;
    private _userProgrammaticAccess?;
    get userProgrammaticAccess(): boolean | cdktf.IResolvable;
    set userProgrammaticAccess(value: boolean | cdktf.IResolvable);
    resetUserProgrammaticAccess(): void;
    get userProgrammaticAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _userRoleTemplateId?;
    get userRoleTemplateId(): string;
    set userRoleTemplateId(value: string);
    resetUserRoleTemplateId(): void;
    get userRoleTemplateIdInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
