import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProducerAwsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The types of credentials to retrieve from AWS. Options:[iam_user,assume_role]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#access_mode ProducerAws#access_mode}
    */
    readonly accessMode?: string;
    /**
    * Access Key ID
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_access_key_id ProducerAws#aws_access_key_id}
    */
    readonly awsAccessKeyId?: string;
    /**
    * Access Secret Key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_access_secret_key ProducerAws#aws_access_secret_key}
    */
    readonly awsAccessSecretKey?: string;
    /**
    * AWS Role ARNs to be use in the Assume Role operation. Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_role_arns ProducerAws#aws_role_arns}
    */
    readonly awsRoleArns?: string;
    /**
    * Enable AWS User console access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_user_console_access ProducerAws#aws_user_console_access}
    */
    readonly awsUserConsoleAccess?: boolean | cdktf.IResolvable;
    /**
    * UserGroup name(s). Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_user_groups ProducerAws#aws_user_groups}
    */
    readonly awsUserGroups?: string;
    /**
    * Policy ARN(s). Multiple values should be separated by comma
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_user_policies ProducerAws#aws_user_policies}
    */
    readonly awsUserPolicies?: string;
    /**
    * Enable AWS User programmatic access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#aws_user_programmatic_access ProducerAws#aws_user_programmatic_access}
    */
    readonly awsUserProgrammaticAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#id ProducerAws#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Producer name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#name ProducerAws#name}
    */
    readonly name: string;
    /**
    * Encrypt producer with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#producer_encryption_key_name ProducerAws#producer_encryption_key_name}
    */
    readonly producerEncryptionKeyName?: string;
    /**
    * Region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#region ProducerAws#region}
    */
    readonly region?: string;
    /**
    * The aws account id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_aws_account_id ProducerAws#secure_access_aws_account_id}
    */
    readonly secureAccessAwsAccountId?: string;
    /**
    * The aws native cli
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_aws_native_cli ProducerAws#secure_access_aws_native_cli}
    */
    readonly secureAccessAwsNativeCli?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_aws_region ProducerAws#secure_access_aws_region}
    */
    readonly secureAccessAwsRegion?: string;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_bastion_issuer ProducerAws#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_enable ProducerAws#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_url ProducerAws#secure_access_url}
    */
    readonly secureAccessUrl?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_web ProducerAws#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * Secure browser via Akeyless Web Access Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#secure_access_web_browsing ProducerAws#secure_access_web_browsing}
    */
    readonly secureAccessWebBrowsing?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#tags ProducerAws#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in producer creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#target_name ProducerAws#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#user_ttl ProducerAws#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws akeyless_producer_aws}
*/
export declare class ProducerAws extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_producer_aws";
    /**
    * Generates CDKTF code for importing a ProducerAws resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProducerAws to import
    * @param importFromId The id of the existing ProducerAws that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProducerAws to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/producer_aws akeyless_producer_aws} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProducerAwsConfig
    */
    constructor(scope: Construct, id: string, config: ProducerAwsConfig);
    private _accessMode?;
    get accessMode(): string;
    set accessMode(value: string);
    resetAccessMode(): void;
    get accessModeInput(): string | undefined;
    private _awsAccessKeyId?;
    get awsAccessKeyId(): string;
    set awsAccessKeyId(value: string);
    resetAwsAccessKeyId(): void;
    get awsAccessKeyIdInput(): string | undefined;
    private _awsAccessSecretKey?;
    get awsAccessSecretKey(): string;
    set awsAccessSecretKey(value: string);
    resetAwsAccessSecretKey(): void;
    get awsAccessSecretKeyInput(): string | undefined;
    private _awsRoleArns?;
    get awsRoleArns(): string;
    set awsRoleArns(value: string);
    resetAwsRoleArns(): void;
    get awsRoleArnsInput(): string | undefined;
    private _awsUserConsoleAccess?;
    get awsUserConsoleAccess(): boolean | cdktf.IResolvable;
    set awsUserConsoleAccess(value: boolean | cdktf.IResolvable);
    resetAwsUserConsoleAccess(): void;
    get awsUserConsoleAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _awsUserGroups?;
    get awsUserGroups(): string;
    set awsUserGroups(value: string);
    resetAwsUserGroups(): void;
    get awsUserGroupsInput(): string | undefined;
    private _awsUserPolicies?;
    get awsUserPolicies(): string;
    set awsUserPolicies(value: string);
    resetAwsUserPolicies(): void;
    get awsUserPoliciesInput(): string | undefined;
    private _awsUserProgrammaticAccess?;
    get awsUserProgrammaticAccess(): boolean | cdktf.IResolvable;
    set awsUserProgrammaticAccess(value: boolean | cdktf.IResolvable);
    resetAwsUserProgrammaticAccess(): void;
    get awsUserProgrammaticAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _producerEncryptionKeyName?;
    get producerEncryptionKeyName(): string;
    set producerEncryptionKeyName(value: string);
    resetProducerEncryptionKeyName(): void;
    get producerEncryptionKeyNameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _secureAccessAwsAccountId?;
    get secureAccessAwsAccountId(): string;
    set secureAccessAwsAccountId(value: string);
    resetSecureAccessAwsAccountId(): void;
    get secureAccessAwsAccountIdInput(): string | undefined;
    private _secureAccessAwsNativeCli?;
    get secureAccessAwsNativeCli(): boolean | cdktf.IResolvable;
    set secureAccessAwsNativeCli(value: boolean | cdktf.IResolvable);
    resetSecureAccessAwsNativeCli(): void;
    get secureAccessAwsNativeCliInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessAwsRegion?;
    get secureAccessAwsRegion(): string;
    set secureAccessAwsRegion(value: string);
    resetSecureAccessAwsRegion(): void;
    get secureAccessAwsRegionInput(): string | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessUrl?;
    get secureAccessUrl(): string;
    set secureAccessUrl(value: string);
    resetSecureAccessUrl(): void;
    get secureAccessUrlInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessWebBrowsing?;
    get secureAccessWebBrowsing(): boolean | cdktf.IResolvable;
    set secureAccessWebBrowsing(value: boolean | cdktf.IResolvable);
    resetSecureAccessWebBrowsing(): void;
    get secureAccessWebBrowsingInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
