import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface K8SAuthConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The access ID of the Kubernetes auth method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#access_id K8SAuthConfig#access_id}
    */
    readonly accessId: string;
    /**
    * Cluster access type. options: [native_k8s, rancher]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#cluster_api_type K8SAuthConfig#cluster_api_type}
    */
    readonly clusterApiType?: string;
    /**
    * Disable issuer validation [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#disable_issuer_validation K8SAuthConfig#disable_issuer_validation}
    */
    readonly disableIssuerValidation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#id K8SAuthConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Native K8S auth type, [token/certificate]. (relevant for native_k8s only)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#k8s_auth_type K8SAuthConfig#k8s_auth_type}
    */
    readonly k8SAuthType?: string;
    /**
    * The CA Certificate (base64 encoded) to use to call into the kubernetes API server
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#k8s_ca_cert K8SAuthConfig#k8s_ca_cert}
    */
    readonly k8SCaCert?: string;
    /**
    * Content of the k8 client certificate (PEM format) in a Base64 format (relevant for native_k8s only)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#k8s_client_certificate K8SAuthConfig#k8s_client_certificate}
    */
    readonly k8SClientCertificate?: string;
    /**
    * Content of the k8 client private key (PEM format) in a Base64 format (relevant for native_k8s only)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#k8s_client_key K8SAuthConfig#k8s_client_key}
    */
    readonly k8SClientKey?: string;
    /**
    * The URL of the kubernetes API server
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#k8s_host K8SAuthConfig#k8s_host}
    */
    readonly k8SHost?: string;
    /**
    * The Kubernetes JWT issuer name. If not set, this <kubernetes/serviceaccount> will be used by default.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#k8s_issuer K8SAuthConfig#k8s_issuer}
    */
    readonly k8SIssuer?: string;
    /**
    * K8S Auth config name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#name K8SAuthConfig#name}
    */
    readonly name: string;
    /**
    * The api key used to access the TokenReview API to validate other JWTs (relevant for rancher only)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#rancher_api_key K8SAuthConfig#rancher_api_key}
    */
    readonly rancherApiKey?: string;
    /**
    * The cluster id as define in rancher (relevant for rancher only)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#rancher_cluster_id K8SAuthConfig#rancher_cluster_id}
    */
    readonly rancherClusterId?: string;
    /**
    * The private key (in base64 encoded of the PEM format) associated with the public key defined in the Kubernetes auth
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#signing_key K8SAuthConfig#signing_key}
    */
    readonly signingKey?: string;
    /**
    * Time in seconds of expiration of the Akeyless Kube Auth Method token
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#token_exp K8SAuthConfig#token_exp}
    */
    readonly tokenExp?: number;
    /**
    * A Kubernetes service account JWT used to access the TokenReview API to validate other JWTs. If not set, the JWT submitted in the authentication process will be used to access the Kubernetes TokenReview API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#token_reviewer_jwt K8SAuthConfig#token_reviewer_jwt}
    */
    readonly tokenReviewerJwt?: string;
    /**
    * Use the GW's service account
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#use_local_ca_jwt K8SAuthConfig#use_local_ca_jwt}
    */
    readonly useLocalCaJwt?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config akeyless_k8s_auth_config}
*/
export declare class K8SAuthConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_k8s_auth_config";
    /**
    * Generates CDKTF code for importing a K8SAuthConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the K8SAuthConfig to import
    * @param importFromId The id of the existing K8SAuthConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the K8SAuthConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/k8s_auth_config akeyless_k8s_auth_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options K8SAuthConfigConfig
    */
    constructor(scope: Construct, id: string, config: K8SAuthConfigConfig);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    get accessIdInput(): string | undefined;
    private _clusterApiType?;
    get clusterApiType(): string;
    set clusterApiType(value: string);
    resetClusterApiType(): void;
    get clusterApiTypeInput(): string | undefined;
    private _disableIssuerValidation?;
    get disableIssuerValidation(): string;
    set disableIssuerValidation(value: string);
    resetDisableIssuerValidation(): void;
    get disableIssuerValidationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _k8SAuthType?;
    get k8SAuthType(): string;
    set k8SAuthType(value: string);
    resetK8SAuthType(): void;
    get k8SAuthTypeInput(): string | undefined;
    private _k8SCaCert?;
    get k8SCaCert(): string;
    set k8SCaCert(value: string);
    resetK8SCaCert(): void;
    get k8SCaCertInput(): string | undefined;
    private _k8SClientCertificate?;
    get k8SClientCertificate(): string;
    set k8SClientCertificate(value: string);
    resetK8SClientCertificate(): void;
    get k8SClientCertificateInput(): string | undefined;
    private _k8SClientKey?;
    get k8SClientKey(): string;
    set k8SClientKey(value: string);
    resetK8SClientKey(): void;
    get k8SClientKeyInput(): string | undefined;
    private _k8SHost?;
    get k8SHost(): string;
    set k8SHost(value: string);
    resetK8SHost(): void;
    get k8SHostInput(): string | undefined;
    private _k8SIssuer?;
    get k8SIssuer(): string;
    set k8SIssuer(value: string);
    resetK8SIssuer(): void;
    get k8SIssuerInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rancherApiKey?;
    get rancherApiKey(): string;
    set rancherApiKey(value: string);
    resetRancherApiKey(): void;
    get rancherApiKeyInput(): string | undefined;
    private _rancherClusterId?;
    get rancherClusterId(): string;
    set rancherClusterId(value: string);
    resetRancherClusterId(): void;
    get rancherClusterIdInput(): string | undefined;
    private _signingKey?;
    get signingKey(): string;
    set signingKey(value: string);
    resetSigningKey(): void;
    get signingKeyInput(): string | undefined;
    private _tokenExp?;
    get tokenExp(): number;
    set tokenExp(value: number);
    resetTokenExp(): void;
    get tokenExpInput(): number | undefined;
    private _tokenReviewerJwt?;
    get tokenReviewerJwt(): string;
    set tokenReviewerJwt(value: string);
    resetTokenReviewerJwt(): void;
    get tokenReviewerJwtInput(): string | undefined;
    private _useLocalCaJwt?;
    get useLocalCaJwt(): boolean | cdktf.IResolvable;
    set useLocalCaJwt(value: boolean | cdktf.IResolvable);
    resetUseLocalCaJwt(): void;
    get useLocalCaJwtInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
