import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayRemoteAccessRdpRecordingConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS access key id. For more information refer to https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#aws_storage_access_key_id GatewayRemoteAccessRdpRecording#aws_storage_access_key_id}
    */
    readonly awsStorageAccessKeyId?: string;
    /**
    * The AWS bucket name. For more information refer to https://docs.aws.amazon.com/s3/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#aws_storage_bucket_name GatewayRemoteAccessRdpRecording#aws_storage_bucket_name}
    */
    readonly awsStorageBucketName?: string;
    /**
    * The folder name in S3 bucket. For more information refer to https://docs.aws.amazon.com/s3/
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#aws_storage_bucket_prefix GatewayRemoteAccessRdpRecording#aws_storage_bucket_prefix}
    */
    readonly awsStorageBucketPrefix?: string;
    /**
    * The region where the storage is located
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#aws_storage_region GatewayRemoteAccessRdpRecording#aws_storage_region}
    */
    readonly awsStorageRegion?: string;
    /**
    * AWS secret access key. For more information refer to https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#aws_storage_secret_access_key GatewayRemoteAccessRdpRecording#aws_storage_secret_access_key}
    */
    readonly awsStorageSecretAccessKey?: string;
    /**
    * Azure account name. For more information refer to https://learn.microsoft.com/en-us/azure/storage/common/storage-account-overview
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#azure_storage_account_name GatewayRemoteAccessRdpRecording#azure_storage_account_name}
    */
    readonly azureStorageAccountName?: string;
    /**
    * Azure client id. For more information refer to https://learn.microsoft.com/en-us/azure/storage/common/storage-account-get-info?tabs=portal
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#azure_storage_client_id GatewayRemoteAccessRdpRecording#azure_storage_client_id}
    */
    readonly azureStorageClientId?: string;
    /**
    * Azure client secret. For more information refer to https://learn.microsoft.com/en-us/azure/storage/common/storage-account-get-info?tabs=portal
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#azure_storage_client_secret GatewayRemoteAccessRdpRecording#azure_storage_client_secret}
    */
    readonly azureStorageClientSecret?: string;
    /**
    * Azure container name. For more information refer to https://learn.microsoft.com/en-us/rest/api/storageservices/naming-and-referencing-containers--blobs--and-metadata
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#azure_storage_container_name GatewayRemoteAccessRdpRecording#azure_storage_container_name}
    */
    readonly azureStorageContainerName?: string;
    /**
    * Azure tenant id. For more information refer to https://learn.microsoft.com/en-us/entra/fundamentals/how-to-find-tenant
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#azure_storage_tenant_id GatewayRemoteAccessRdpRecording#azure_storage_tenant_id}
    */
    readonly azureStorageTenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#id GatewayRemoteAccessRdpRecording#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Enable recording of rdp session [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#rdp_session_recording GatewayRemoteAccessRdpRecording#rdp_session_recording}
    */
    readonly rdpSessionRecording?: string;
    /**
    * Rdp session recording storage destination [local/aws/azure]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#rdp_session_storage GatewayRemoteAccessRdpRecording#rdp_session_storage}
    */
    readonly rdpSessionStorage?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording akeyless_gateway_remote_access_rdp_recording}
*/
export declare class GatewayRemoteAccessRdpRecording extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_remote_access_rdp_recording";
    /**
    * Generates CDKTF code for importing a GatewayRemoteAccessRdpRecording resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayRemoteAccessRdpRecording to import
    * @param importFromId The id of the existing GatewayRemoteAccessRdpRecording that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayRemoteAccessRdpRecording to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_remote_access_rdp_recording akeyless_gateway_remote_access_rdp_recording} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayRemoteAccessRdpRecordingConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayRemoteAccessRdpRecordingConfig);
    private _awsStorageAccessKeyId?;
    get awsStorageAccessKeyId(): string;
    set awsStorageAccessKeyId(value: string);
    resetAwsStorageAccessKeyId(): void;
    get awsStorageAccessKeyIdInput(): string | undefined;
    private _awsStorageBucketName?;
    get awsStorageBucketName(): string;
    set awsStorageBucketName(value: string);
    resetAwsStorageBucketName(): void;
    get awsStorageBucketNameInput(): string | undefined;
    private _awsStorageBucketPrefix?;
    get awsStorageBucketPrefix(): string;
    set awsStorageBucketPrefix(value: string);
    resetAwsStorageBucketPrefix(): void;
    get awsStorageBucketPrefixInput(): string | undefined;
    private _awsStorageRegion?;
    get awsStorageRegion(): string;
    set awsStorageRegion(value: string);
    resetAwsStorageRegion(): void;
    get awsStorageRegionInput(): string | undefined;
    private _awsStorageSecretAccessKey?;
    get awsStorageSecretAccessKey(): string;
    set awsStorageSecretAccessKey(value: string);
    resetAwsStorageSecretAccessKey(): void;
    get awsStorageSecretAccessKeyInput(): string | undefined;
    private _azureStorageAccountName?;
    get azureStorageAccountName(): string;
    set azureStorageAccountName(value: string);
    resetAzureStorageAccountName(): void;
    get azureStorageAccountNameInput(): string | undefined;
    private _azureStorageClientId?;
    get azureStorageClientId(): string;
    set azureStorageClientId(value: string);
    resetAzureStorageClientId(): void;
    get azureStorageClientIdInput(): string | undefined;
    private _azureStorageClientSecret?;
    get azureStorageClientSecret(): string;
    set azureStorageClientSecret(value: string);
    resetAzureStorageClientSecret(): void;
    get azureStorageClientSecretInput(): string | undefined;
    private _azureStorageContainerName?;
    get azureStorageContainerName(): string;
    set azureStorageContainerName(value: string);
    resetAzureStorageContainerName(): void;
    get azureStorageContainerNameInput(): string | undefined;
    private _azureStorageTenantId?;
    get azureStorageTenantId(): string;
    set azureStorageTenantId(value: string);
    resetAzureStorageTenantId(): void;
    get azureStorageTenantIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _rdpSessionRecording?;
    get rdpSessionRecording(): string;
    set rdpSessionRecording(value: string);
    resetRdpSessionRecording(): void;
    get rdpSessionRecordingInput(): string | undefined;
    private _rdpSessionStorage?;
    get rdpSessionStorage(): string;
    set rdpSessionStorage(value: string);
    resetRdpSessionStorage(): void;
    get rdpSessionStorageInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
