import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingSyslogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#enable GatewayLogForwardingSyslog#enable}
    */
    readonly enable?: string;
    /**
    * Enable tls relevant only for network type TCP
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#enable_tls GatewayLogForwardingSyslog#enable_tls}
    */
    readonly enableTls?: boolean | cdktf.IResolvable;
    /**
    * Syslog formatter [text/cef]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#formatter GatewayLogForwardingSyslog#formatter}
    */
    readonly formatter?: string;
    /**
    * Syslog host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#host GatewayLogForwardingSyslog#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#id GatewayLogForwardingSyslog#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Syslog network [tcp/udp]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#network GatewayLogForwardingSyslog#network}
    */
    readonly network?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#output_format GatewayLogForwardingSyslog#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#pull_interval GatewayLogForwardingSyslog#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * Syslog target tag
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#target_tag GatewayLogForwardingSyslog#target_tag}
    */
    readonly targetTag?: string;
    /**
    * Syslog tls certificate (PEM format) in a Base64 format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#tls_certificate GatewayLogForwardingSyslog#tls_certificate}
    */
    readonly tlsCertificate?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog akeyless_gateway_log_forwarding_syslog}
*/
export declare class GatewayLogForwardingSyslog extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_syslog";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingSyslog resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingSyslog to import
    * @param importFromId The id of the existing GatewayLogForwardingSyslog that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingSyslog to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_syslog akeyless_gateway_log_forwarding_syslog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingSyslogConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingSyslogConfig);
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _enableTls?;
    get enableTls(): boolean | cdktf.IResolvable;
    set enableTls(value: boolean | cdktf.IResolvable);
    resetEnableTls(): void;
    get enableTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _formatter?;
    get formatter(): string;
    set formatter(value: string);
    resetFormatter(): void;
    get formatterInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _targetTag?;
    get targetTag(): string;
    set targetTag(value: string);
    resetTargetTag(): void;
    get targetTagInput(): string | undefined;
    private _tlsCertificate?;
    get tlsCertificate(): string;
    set tlsCertificate(value: string);
    resetTlsCertificate(): void;
    get tlsCertificateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
