import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingLogstashConfig extends cdktf.TerraformMetaArguments {
    /**
    * Logstash dns
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#dns GatewayLogForwardingLogstash#dns}
    */
    readonly dns?: string;
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#enable GatewayLogForwardingLogstash#enable}
    */
    readonly enable?: string;
    /**
    * Enable tls
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#enable_tls GatewayLogForwardingLogstash#enable_tls}
    */
    readonly enableTls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#id GatewayLogForwardingLogstash#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#output_format GatewayLogForwardingLogstash#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Logstash protocol [tcp/udp]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#protocol GatewayLogForwardingLogstash#protocol}
    */
    readonly protocol?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#pull_interval GatewayLogForwardingLogstash#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * Logstash tls certificate (PEM format) in a Base64 format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#tls_certificate GatewayLogForwardingLogstash#tls_certificate}
    */
    readonly tlsCertificate?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash akeyless_gateway_log_forwarding_logstash}
*/
export declare class GatewayLogForwardingLogstash extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_logstash";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingLogstash resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingLogstash to import
    * @param importFromId The id of the existing GatewayLogForwardingLogstash that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingLogstash to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_logstash akeyless_gateway_log_forwarding_logstash} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingLogstashConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingLogstashConfig);
    private _dns?;
    get dns(): string;
    set dns(value: string);
    resetDns(): void;
    get dnsInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _enableTls?;
    get enableTls(): boolean | cdktf.IResolvable;
    set enableTls(value: boolean | cdktf.IResolvable);
    resetEnableTls(): void;
    get enableTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _tlsCertificate?;
    get tlsCertificate(): string;
    set tlsCertificate(value: string);
    resetTlsCertificate(): void;
    get tlsCertificateInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
