import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingGoogleChronicleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Google chronicle customer id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#customer_id GatewayLogForwardingGoogleChronicle#customer_id}
    */
    readonly customerId?: string;
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#enable GatewayLogForwardingGoogleChronicle#enable}
    */
    readonly enable?: string;
    /**
    * Base64-encoded service account private key text
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#gcp_key GatewayLogForwardingGoogleChronicle#gcp_key}
    */
    readonly gcpKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#id GatewayLogForwardingGoogleChronicle#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Google chronicle log type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#log_type GatewayLogForwardingGoogleChronicle#log_type}
    */
    readonly logType?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#output_format GatewayLogForwardingGoogleChronicle#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#pull_interval GatewayLogForwardingGoogleChronicle#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * Google chronicle region [eu_multi_region/london/us_multi_region/singapore/tel_aviv]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#region GatewayLogForwardingGoogleChronicle#region}
    */
    readonly region?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle akeyless_gateway_log_forwarding_google_chronicle}
*/
export declare class GatewayLogForwardingGoogleChronicle extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_google_chronicle";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingGoogleChronicle resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingGoogleChronicle to import
    * @param importFromId The id of the existing GatewayLogForwardingGoogleChronicle that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingGoogleChronicle to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_google_chronicle akeyless_gateway_log_forwarding_google_chronicle} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingGoogleChronicleConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingGoogleChronicleConfig);
    private _customerId?;
    get customerId(): string;
    set customerId(value: string);
    resetCustomerId(): void;
    get customerIdInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _gcpKey?;
    get gcpKey(): string;
    set gcpKey(value: string);
    resetGcpKey(): void;
    get gcpKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logType?;
    get logType(): string;
    set logType(value: string);
    resetLogType(): void;
    get logTypeInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
