import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingDatadogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Datadog api key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#api_key GatewayLogForwardingDatadog#api_key}
    */
    readonly apiKey?: string;
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#enable GatewayLogForwardingDatadog#enable}
    */
    readonly enable?: string;
    /**
    * Datadog host
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#host GatewayLogForwardingDatadog#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#id GatewayLogForwardingDatadog#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Datadog log service
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#log_service GatewayLogForwardingDatadog#log_service}
    */
    readonly logService?: string;
    /**
    * Datadog log source
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#log_source GatewayLogForwardingDatadog#log_source}
    */
    readonly logSource?: string;
    /**
    * A comma-separated list of Datadog log tags formatted as key:value strings
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#log_tags GatewayLogForwardingDatadog#log_tags}
    */
    readonly logTags?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#output_format GatewayLogForwardingDatadog#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#pull_interval GatewayLogForwardingDatadog#pull_interval}
    */
    readonly pullInterval?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog akeyless_gateway_log_forwarding_datadog}
*/
export declare class GatewayLogForwardingDatadog extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_datadog";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingDatadog resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingDatadog to import
    * @param importFromId The id of the existing GatewayLogForwardingDatadog that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingDatadog to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_datadog akeyless_gateway_log_forwarding_datadog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingDatadogConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingDatadogConfig);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logService?;
    get logService(): string;
    set logService(value: string);
    resetLogService(): void;
    get logServiceInput(): string | undefined;
    private _logSource?;
    get logSource(): string;
    set logSource(value: string);
    resetLogSource(): void;
    get logSourceInput(): string | undefined;
    private _logTags?;
    get logTags(): string;
    set logTags(value: string);
    resetLogTags(): void;
    get logTagsInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
