import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingAzureAnalyticsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#enable GatewayLogForwardingAzureAnalytics#enable}
    */
    readonly enable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#id GatewayLogForwardingAzureAnalytics#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#output_format GatewayLogForwardingAzureAnalytics#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#pull_interval GatewayLogForwardingAzureAnalytics#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * Azure workspace id
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#workspace_id GatewayLogForwardingAzureAnalytics#workspace_id}
    */
    readonly workspaceId?: string;
    /**
    * Azure workspace key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#workspace_key GatewayLogForwardingAzureAnalytics#workspace_key}
    */
    readonly workspaceKey?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics akeyless_gateway_log_forwarding_azure_analytics}
*/
export declare class GatewayLogForwardingAzureAnalytics extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_azure_analytics";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingAzureAnalytics resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingAzureAnalytics to import
    * @param importFromId The id of the existing GatewayLogForwardingAzureAnalytics that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingAzureAnalytics to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_azure_analytics akeyless_gateway_log_forwarding_azure_analytics} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingAzureAnalyticsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingAzureAnalyticsConfig);
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    resetWorkspaceId(): void;
    get workspaceIdInput(): string | undefined;
    private _workspaceKey?;
    get workspaceKey(): string;
    set workspaceKey(value: string);
    resetWorkspaceKey(): void;
    get workspaceKeyInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
