import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GatewayLogForwardingAwsS3Config extends cdktf.TerraformMetaArguments {
    /**
    * AWS access id relevant for access_key auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#access_id GatewayLogForwardingAwsS3#access_id}
    */
    readonly accessId?: string;
    /**
    * AWS access key relevant for access_key auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#access_key GatewayLogForwardingAwsS3#access_key}
    */
    readonly accessKey?: string;
    /**
    * AWS auth type [access_key/cloud_id/assume_role]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#auth_type GatewayLogForwardingAwsS3#auth_type}
    */
    readonly authType?: string;
    /**
    * AWS S3 bucket name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#bucket_name GatewayLogForwardingAwsS3#bucket_name}
    */
    readonly bucketName?: string;
    /**
    * Enable Log Forwarding [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#enable GatewayLogForwardingAwsS3#enable}
    */
    readonly enable?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#id GatewayLogForwardingAwsS3#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * AWS S3 destination folder for logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#log_folder GatewayLogForwardingAwsS3#log_folder}
    */
    readonly logFolder?: string;
    /**
    * Logs format [text/json]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#output_format GatewayLogForwardingAwsS3#output_format}
    */
    readonly outputFormat?: string;
    /**
    * Pull interval in seconds
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#pull_interval GatewayLogForwardingAwsS3#pull_interval}
    */
    readonly pullInterval?: string;
    /**
    * AWS region
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#region GatewayLogForwardingAwsS3#region}
    */
    readonly region?: string;
    /**
    * AWS role arn relevant for assume_role auth-type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#role_arn GatewayLogForwardingAwsS3#role_arn}
    */
    readonly roleArn?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3 akeyless_gateway_log_forwarding_aws_s3}
*/
export declare class GatewayLogForwardingAwsS3 extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_gateway_log_forwarding_aws_s3";
    /**
    * Generates CDKTF code for importing a GatewayLogForwardingAwsS3 resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the GatewayLogForwardingAwsS3 to import
    * @param importFromId The id of the existing GatewayLogForwardingAwsS3 that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the GatewayLogForwardingAwsS3 to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/gateway_log_forwarding_aws_s3 akeyless_gateway_log_forwarding_aws_s3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GatewayLogForwardingAwsS3Config = {}
    */
    constructor(scope: Construct, id: string, config?: GatewayLogForwardingAwsS3Config);
    private _accessId?;
    get accessId(): string;
    set accessId(value: string);
    resetAccessId(): void;
    get accessIdInput(): string | undefined;
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    resetBucketName(): void;
    get bucketNameInput(): string | undefined;
    private _enable?;
    get enable(): string;
    set enable(value: string);
    resetEnable(): void;
    get enableInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logFolder?;
    get logFolder(): string;
    set logFolder(value: string);
    resetLogFolder(): void;
    get logFolderInput(): string | undefined;
    private _outputFormat?;
    get outputFormat(): string;
    set outputFormat(value: string);
    resetOutputFormat(): void;
    get outputFormatInput(): string | undefined;
    private _pullInterval?;
    get pullInterval(): string;
    set pullInterval(value: string);
    resetPullInterval(): void;
    get pullIntervalInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    resetRoleArn(): void;
    get roleArnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
