import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventForwarderSlackConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth Methods event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#auth_methods_event_source_locations EventForwarderSlack#auth_methods_event_source_locations}
    */
    readonly authMethodsEventSourceLocations?: string[];
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#description EventForwarderSlack#description}
    */
    readonly description?: string;
    /**
    * A comma-separated list of types of events to notify about
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#event_types EventForwarderSlack#event_types}
    */
    readonly eventTypes?: string[];
    /**
    * Rate of periodic runner repetition in hours
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#every EventForwarderSlack#every}
    */
    readonly every?: string;
    /**
    * Gateways event sources to forward events about,for example the relevant Gateways cluster urls,: http://localhost:8000.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#gateways_event_source_locations EventForwarderSlack#gateways_event_source_locations}
    */
    readonly gatewaysEventSourceLocations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#id EventForwarderSlack#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Items event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#items_event_source_locations EventForwarderSlack#items_event_source_locations}
    */
    readonly itemsEventSourceLocations?: string[];
    /**
    * Key name. The key will be used to encrypt the Event Forwarder secret value. If key name is not specified, the account default protection key is used
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#key EventForwarderSlack#key}
    */
    readonly key?: string;
    /**
    * Event Forwarder name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#name EventForwarderSlack#name}
    */
    readonly name: string;
    /**
    * Event Forwarder runner type [immediate/periodic]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#runner_type EventForwarderSlack#runner_type}
    */
    readonly runnerType?: string;
    /**
    * Targets event sources to forward events about, for example: /abc/*
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#targets_event_source_locations EventForwarderSlack#targets_event_source_locations}
    */
    readonly targetsEventSourceLocations?: string[];
    /**
    * Slack Webhook URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#url EventForwarderSlack#url}
    */
    readonly url: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack akeyless_event_forwarder_slack}
*/
export declare class EventForwarderSlack extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_event_forwarder_slack";
    /**
    * Generates CDKTF code for importing a EventForwarderSlack resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventForwarderSlack to import
    * @param importFromId The id of the existing EventForwarderSlack that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventForwarderSlack to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/event_forwarder_slack akeyless_event_forwarder_slack} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventForwarderSlackConfig
    */
    constructor(scope: Construct, id: string, config: EventForwarderSlackConfig);
    private _authMethodsEventSourceLocations?;
    get authMethodsEventSourceLocations(): string[];
    set authMethodsEventSourceLocations(value: string[]);
    resetAuthMethodsEventSourceLocations(): void;
    get authMethodsEventSourceLocationsInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    private _every?;
    get every(): string;
    set every(value: string);
    resetEvery(): void;
    get everyInput(): string | undefined;
    private _gatewaysEventSourceLocations?;
    get gatewaysEventSourceLocations(): string[];
    set gatewaysEventSourceLocations(value: string[]);
    resetGatewaysEventSourceLocations(): void;
    get gatewaysEventSourceLocationsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _itemsEventSourceLocations?;
    get itemsEventSourceLocations(): string[];
    set itemsEventSourceLocations(value: string[]);
    resetItemsEventSourceLocations(): void;
    get itemsEventSourceLocationsInput(): string[] | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _runnerType?;
    get runnerType(): string;
    set runnerType(value: string);
    resetRunnerType(): void;
    get runnerTypeInput(): string | undefined;
    private _targetsEventSourceLocations?;
    get targetsEventSourceLocations(): string[];
    set targetsEventSourceLocations(value: string[]);
    resetTargetsEventSourceLocations(): void;
    get targetsEventSourceLocationsInput(): string[] | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
