import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretRedshiftConfig extends cdktf.TerraformMetaArguments {
    /**
    * Redshift Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#creation_statements DynamicSecretRedshift#creation_statements}
    */
    readonly creationStatements?: string;
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#custom_username_template DynamicSecretRedshift#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#encryption_key_name DynamicSecretRedshift#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#id DynamicSecretRedshift#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic Secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#name DynamicSecretRedshift#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#password_length DynamicSecretRedshift#password_length}
    */
    readonly passwordLength?: string;
    /**
    * Redshift DB name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#redshift_db_name DynamicSecretRedshift#redshift_db_name}
    */
    readonly redshiftDbName?: string;
    /**
    * Redshift host name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#redshift_host DynamicSecretRedshift#redshift_host}
    */
    readonly redshiftHost?: string;
    /**
    * Redshift password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#redshift_password DynamicSecretRedshift#redshift_password}
    */
    readonly redshiftPassword?: string;
    /**
    * Redshift port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#redshift_port DynamicSecretRedshift#redshift_port}
    */
    readonly redshiftPort?: string;
    /**
    * redshiftL user
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#redshift_username DynamicSecretRedshift#redshift_username}
    */
    readonly redshiftUsername?: string;
    /**
    * The DB Name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#secure_access_db_name DynamicSecretRedshift#secure_access_db_name}
    */
    readonly secureAccessDbName?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#secure_access_enable DynamicSecretRedshift#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Target DB servers for connections., For multiple values repeat this flag.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#secure_access_host DynamicSecretRedshift#secure_access_host}
    */
    readonly secureAccessHost?: string[];
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#secure_access_web DynamicSecretRedshift#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * Enable/Disable SSL [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#ssl DynamicSecretRedshift#ssl}
    */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#tags DynamicSecretRedshift#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#target_name DynamicSecretRedshift#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#user_ttl DynamicSecretRedshift#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift akeyless_dynamic_secret_redshift}
*/
export declare class DynamicSecretRedshift extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_redshift";
    /**
    * Generates CDKTF code for importing a DynamicSecretRedshift resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretRedshift to import
    * @param importFromId The id of the existing DynamicSecretRedshift that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretRedshift to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_redshift akeyless_dynamic_secret_redshift} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretRedshiftConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretRedshiftConfig);
    private _creationStatements?;
    get creationStatements(): string;
    set creationStatements(value: string);
    resetCreationStatements(): void;
    get creationStatementsInput(): string | undefined;
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _redshiftDbName?;
    get redshiftDbName(): string;
    set redshiftDbName(value: string);
    resetRedshiftDbName(): void;
    get redshiftDbNameInput(): string | undefined;
    private _redshiftHost?;
    get redshiftHost(): string;
    set redshiftHost(value: string);
    resetRedshiftHost(): void;
    get redshiftHostInput(): string | undefined;
    private _redshiftPassword?;
    get redshiftPassword(): string;
    set redshiftPassword(value: string);
    resetRedshiftPassword(): void;
    get redshiftPasswordInput(): string | undefined;
    private _redshiftPort?;
    get redshiftPort(): string;
    set redshiftPort(value: string);
    resetRedshiftPort(): void;
    get redshiftPortInput(): string | undefined;
    private _redshiftUsername?;
    get redshiftUsername(): string;
    set redshiftUsername(value: string);
    resetRedshiftUsername(): void;
    get redshiftUsernameInput(): string | undefined;
    private _secureAccessDbName?;
    get secureAccessDbName(): string;
    set secureAccessDbName(value: string);
    resetSecureAccessDbName(): void;
    get secureAccessDbNameInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessHost?;
    get secureAccessHost(): string[];
    set secureAccessHost(value: string[]);
    resetSecureAccessHost(): void;
    get secureAccessHostInput(): string[] | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _ssl?;
    get ssl(): boolean | cdktf.IResolvable;
    set ssl(value: boolean | cdktf.IResolvable);
    resetSsl(): void;
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
