"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamicSecretMongodb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mongodb akeyless_dynamic_secret_mongodb}
*/
class DynamicSecretMongodb extends cdktf.TerraformResource {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DynamicSecretMongodb resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretMongodb to import
    * @param importFromId The id of the existing DynamicSecretMongodb that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mongodb#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretMongodb to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "akeyless_dynamic_secret_mongodb", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_mongodb akeyless_dynamic_secret_mongodb} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretMongodbConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'akeyless_dynamic_secret_mongodb',
            terraformGeneratorMetadata: {
                providerName: 'akeyless',
                providerVersion: '1.11.2',
                providerVersionConstraint: '~> 1.11.2'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._customUsernameTemplate = config.customUsernameTemplate;
        this._encryptionKeyName = config.encryptionKeyName;
        this._id = config.id;
        this._mongodbAtlasApiPrivateKey = config.mongodbAtlasApiPrivateKey;
        this._mongodbAtlasApiPublicKey = config.mongodbAtlasApiPublicKey;
        this._mongodbAtlasProjectId = config.mongodbAtlasProjectId;
        this._mongodbDefaultAuthDb = config.mongodbDefaultAuthDb;
        this._mongodbHostPort = config.mongodbHostPort;
        this._mongodbName = config.mongodbName;
        this._mongodbPassword = config.mongodbPassword;
        this._mongodbRoles = config.mongodbRoles;
        this._mongodbServerUri = config.mongodbServerUri;
        this._mongodbUriOptions = config.mongodbUriOptions;
        this._mongodbUsername = config.mongodbUsername;
        this._name = config.name;
        this._passwordLength = config.passwordLength;
        this._secureAccessBastionIssuer = config.secureAccessBastionIssuer;
        this._secureAccessDbName = config.secureAccessDbName;
        this._secureAccessEnable = config.secureAccessEnable;
        this._secureAccessHost = config.secureAccessHost;
        this._secureAccessWeb = config.secureAccessWeb;
        this._tags = config.tags;
        this._targetName = config.targetName;
        this._userTtl = config.userTtl;
    }
    get customUsernameTemplate() {
        return this.getStringAttribute('custom_username_template');
    }
    set customUsernameTemplate(value) {
        this._customUsernameTemplate = value;
    }
    resetCustomUsernameTemplate() {
        this._customUsernameTemplate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customUsernameTemplateInput() {
        return this._customUsernameTemplate;
    }
    get encryptionKeyName() {
        return this.getStringAttribute('encryption_key_name');
    }
    set encryptionKeyName(value) {
        this._encryptionKeyName = value;
    }
    resetEncryptionKeyName() {
        this._encryptionKeyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get encryptionKeyNameInput() {
        return this._encryptionKeyName;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get mongodbAtlasApiPrivateKey() {
        return this.getStringAttribute('mongodb_atlas_api_private_key');
    }
    set mongodbAtlasApiPrivateKey(value) {
        this._mongodbAtlasApiPrivateKey = value;
    }
    resetMongodbAtlasApiPrivateKey() {
        this._mongodbAtlasApiPrivateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbAtlasApiPrivateKeyInput() {
        return this._mongodbAtlasApiPrivateKey;
    }
    get mongodbAtlasApiPublicKey() {
        return this.getStringAttribute('mongodb_atlas_api_public_key');
    }
    set mongodbAtlasApiPublicKey(value) {
        this._mongodbAtlasApiPublicKey = value;
    }
    resetMongodbAtlasApiPublicKey() {
        this._mongodbAtlasApiPublicKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbAtlasApiPublicKeyInput() {
        return this._mongodbAtlasApiPublicKey;
    }
    get mongodbAtlasProjectId() {
        return this.getStringAttribute('mongodb_atlas_project_id');
    }
    set mongodbAtlasProjectId(value) {
        this._mongodbAtlasProjectId = value;
    }
    resetMongodbAtlasProjectId() {
        this._mongodbAtlasProjectId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbAtlasProjectIdInput() {
        return this._mongodbAtlasProjectId;
    }
    get mongodbDefaultAuthDb() {
        return this.getStringAttribute('mongodb_default_auth_db');
    }
    set mongodbDefaultAuthDb(value) {
        this._mongodbDefaultAuthDb = value;
    }
    resetMongodbDefaultAuthDb() {
        this._mongodbDefaultAuthDb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbDefaultAuthDbInput() {
        return this._mongodbDefaultAuthDb;
    }
    get mongodbHostPort() {
        return this.getStringAttribute('mongodb_host_port');
    }
    set mongodbHostPort(value) {
        this._mongodbHostPort = value;
    }
    resetMongodbHostPort() {
        this._mongodbHostPort = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbHostPortInput() {
        return this._mongodbHostPort;
    }
    get mongodbName() {
        return this.getStringAttribute('mongodb_name');
    }
    set mongodbName(value) {
        this._mongodbName = value;
    }
    resetMongodbName() {
        this._mongodbName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbNameInput() {
        return this._mongodbName;
    }
    get mongodbPassword() {
        return this.getStringAttribute('mongodb_password');
    }
    set mongodbPassword(value) {
        this._mongodbPassword = value;
    }
    resetMongodbPassword() {
        this._mongodbPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbPasswordInput() {
        return this._mongodbPassword;
    }
    get mongodbRoles() {
        return this.getStringAttribute('mongodb_roles');
    }
    set mongodbRoles(value) {
        this._mongodbRoles = value;
    }
    resetMongodbRoles() {
        this._mongodbRoles = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbRolesInput() {
        return this._mongodbRoles;
    }
    get mongodbServerUri() {
        return this.getStringAttribute('mongodb_server_uri');
    }
    set mongodbServerUri(value) {
        this._mongodbServerUri = value;
    }
    resetMongodbServerUri() {
        this._mongodbServerUri = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbServerUriInput() {
        return this._mongodbServerUri;
    }
    get mongodbUriOptions() {
        return this.getStringAttribute('mongodb_uri_options');
    }
    set mongodbUriOptions(value) {
        this._mongodbUriOptions = value;
    }
    resetMongodbUriOptions() {
        this._mongodbUriOptions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbUriOptionsInput() {
        return this._mongodbUriOptions;
    }
    get mongodbUsername() {
        return this.getStringAttribute('mongodb_username');
    }
    set mongodbUsername(value) {
        this._mongodbUsername = value;
    }
    resetMongodbUsername() {
        this._mongodbUsername = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mongodbUsernameInput() {
        return this._mongodbUsername;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get passwordLength() {
        return this.getStringAttribute('password_length');
    }
    set passwordLength(value) {
        this._passwordLength = value;
    }
    resetPasswordLength() {
        this._passwordLength = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordLengthInput() {
        return this._passwordLength;
    }
    get secureAccessBastionIssuer() {
        return this.getStringAttribute('secure_access_bastion_issuer');
    }
    set secureAccessBastionIssuer(value) {
        this._secureAccessBastionIssuer = value;
    }
    resetSecureAccessBastionIssuer() {
        this._secureAccessBastionIssuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessBastionIssuerInput() {
        return this._secureAccessBastionIssuer;
    }
    get secureAccessDbName() {
        return this.getStringAttribute('secure_access_db_name');
    }
    set secureAccessDbName(value) {
        this._secureAccessDbName = value;
    }
    resetSecureAccessDbName() {
        this._secureAccessDbName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessDbNameInput() {
        return this._secureAccessDbName;
    }
    get secureAccessEnable() {
        return this.getStringAttribute('secure_access_enable');
    }
    set secureAccessEnable(value) {
        this._secureAccessEnable = value;
    }
    resetSecureAccessEnable() {
        this._secureAccessEnable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessEnableInput() {
        return this._secureAccessEnable;
    }
    get secureAccessHost() {
        return cdktf.Fn.tolist(this.getListAttribute('secure_access_host'));
    }
    set secureAccessHost(value) {
        this._secureAccessHost = value;
    }
    resetSecureAccessHost() {
        this._secureAccessHost = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessHostInput() {
        return this._secureAccessHost;
    }
    get secureAccessWeb() {
        return this.getBooleanAttribute('secure_access_web');
    }
    set secureAccessWeb(value) {
        this._secureAccessWeb = value;
    }
    resetSecureAccessWeb() {
        this._secureAccessWeb = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secureAccessWebInput() {
        return this._secureAccessWeb;
    }
    get tags() {
        return cdktf.Fn.tolist(this.getListAttribute('tags'));
    }
    set tags(value) {
        this._tags = value;
    }
    resetTags() {
        this._tags = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tagsInput() {
        return this._tags;
    }
    get targetName() {
        return this.getStringAttribute('target_name');
    }
    set targetName(value) {
        this._targetName = value;
    }
    resetTargetName() {
        this._targetName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get targetNameInput() {
        return this._targetName;
    }
    get userTtl() {
        return this.getStringAttribute('user_ttl');
    }
    set userTtl(value) {
        this._userTtl = value;
    }
    resetUserTtl() {
        this._userTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userTtlInput() {
        return this._userTtl;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            custom_username_template: cdktf.stringToTerraform(this._customUsernameTemplate),
            encryption_key_name: cdktf.stringToTerraform(this._encryptionKeyName),
            id: cdktf.stringToTerraform(this._id),
            mongodb_atlas_api_private_key: cdktf.stringToTerraform(this._mongodbAtlasApiPrivateKey),
            mongodb_atlas_api_public_key: cdktf.stringToTerraform(this._mongodbAtlasApiPublicKey),
            mongodb_atlas_project_id: cdktf.stringToTerraform(this._mongodbAtlasProjectId),
            mongodb_default_auth_db: cdktf.stringToTerraform(this._mongodbDefaultAuthDb),
            mongodb_host_port: cdktf.stringToTerraform(this._mongodbHostPort),
            mongodb_name: cdktf.stringToTerraform(this._mongodbName),
            mongodb_password: cdktf.stringToTerraform(this._mongodbPassword),
            mongodb_roles: cdktf.stringToTerraform(this._mongodbRoles),
            mongodb_server_uri: cdktf.stringToTerraform(this._mongodbServerUri),
            mongodb_uri_options: cdktf.stringToTerraform(this._mongodbUriOptions),
            mongodb_username: cdktf.stringToTerraform(this._mongodbUsername),
            name: cdktf.stringToTerraform(this._name),
            password_length: cdktf.stringToTerraform(this._passwordLength),
            secure_access_bastion_issuer: cdktf.stringToTerraform(this._secureAccessBastionIssuer),
            secure_access_db_name: cdktf.stringToTerraform(this._secureAccessDbName),
            secure_access_enable: cdktf.stringToTerraform(this._secureAccessEnable),
            secure_access_host: cdktf.listMapper(cdktf.stringToTerraform, false)(this._secureAccessHost),
            secure_access_web: cdktf.booleanToTerraform(this._secureAccessWeb),
            tags: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tags),
            target_name: cdktf.stringToTerraform(this._targetName),
            user_ttl: cdktf.stringToTerraform(this._userTtl),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            custom_username_template: {
                value: cdktf.stringToHclTerraform(this._customUsernameTemplate),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            encryption_key_name: {
                value: cdktf.stringToHclTerraform(this._encryptionKeyName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            id: {
                value: cdktf.stringToHclTerraform(this._id),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_atlas_api_private_key: {
                value: cdktf.stringToHclTerraform(this._mongodbAtlasApiPrivateKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_atlas_api_public_key: {
                value: cdktf.stringToHclTerraform(this._mongodbAtlasApiPublicKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_atlas_project_id: {
                value: cdktf.stringToHclTerraform(this._mongodbAtlasProjectId),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_default_auth_db: {
                value: cdktf.stringToHclTerraform(this._mongodbDefaultAuthDb),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_host_port: {
                value: cdktf.stringToHclTerraform(this._mongodbHostPort),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_name: {
                value: cdktf.stringToHclTerraform(this._mongodbName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_password: {
                value: cdktf.stringToHclTerraform(this._mongodbPassword),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_roles: {
                value: cdktf.stringToHclTerraform(this._mongodbRoles),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_server_uri: {
                value: cdktf.stringToHclTerraform(this._mongodbServerUri),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_uri_options: {
                value: cdktf.stringToHclTerraform(this._mongodbUriOptions),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            mongodb_username: {
                value: cdktf.stringToHclTerraform(this._mongodbUsername),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            name: {
                value: cdktf.stringToHclTerraform(this._name),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            password_length: {
                value: cdktf.stringToHclTerraform(this._passwordLength),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_bastion_issuer: {
                value: cdktf.stringToHclTerraform(this._secureAccessBastionIssuer),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_db_name: {
                value: cdktf.stringToHclTerraform(this._secureAccessDbName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_enable: {
                value: cdktf.stringToHclTerraform(this._secureAccessEnable),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            secure_access_host: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._secureAccessHost),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            secure_access_web: {
                value: cdktf.booleanToHclTerraform(this._secureAccessWeb),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tags: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._tags),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            target_name: {
                value: cdktf.stringToHclTerraform(this._targetName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            user_ttl: {
                value: cdktf.stringToHclTerraform(this._userTtl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.DynamicSecretMongodb = DynamicSecretMongodb;
_a = JSII_RTTI_SYMBOL_1;
DynamicSecretMongodb[_a] = { fqn: "akeyless.dynamicSecretMongodb.DynamicSecretMongodb", version: "0.0.0" };
// =================
// STATIC PROPERTIES
// =================
DynamicSecretMongodb.tfResourceType = "akeyless_dynamic_secret_mongodb";
//# sourceMappingURL=data:application/json;base64,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