import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretGkeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#encryption_key_name DynamicSecretGke#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * GKE service account key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#gke_account_key DynamicSecretGke#gke_account_key}
    */
    readonly gkeAccountKey?: string;
    /**
    * GKE Base-64 encoded cluster certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#gke_cluster_cert DynamicSecretGke#gke_cluster_cert}
    */
    readonly gkeClusterCert?: string;
    /**
    * GKE cluster endpoint, i.e., cluster URI https://<DNS/IP>.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#gke_cluster_endpoint DynamicSecretGke#gke_cluster_endpoint}
    */
    readonly gkeClusterEndpoint?: string;
    /**
    * GKE cluster name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#gke_cluster_name DynamicSecretGke#gke_cluster_name}
    */
    readonly gkeClusterName?: string;
    /**
    * GKE service account email
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#gke_service_account_email DynamicSecretGke#gke_service_account_email}
    */
    readonly gkeServiceAccountEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#id DynamicSecretGke#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#name DynamicSecretGke#name}
    */
    readonly name: string;
    /**
    * Enable Port forwarding while using CLI access.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#secure_access_allow_port_forwading DynamicSecretGke#secure_access_allow_port_forwading}
    */
    readonly secureAccessAllowPortForwading?: boolean | cdktf.IResolvable;
    /**
    * Path to the SSH Certificate Issuer for your Akeyless Bastion
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#secure_access_bastion_issuer DynamicSecretGke#secure_access_bastion_issuer}
    */
    readonly secureAccessBastionIssuer?: string;
    /**
    * The K8s cluster endpoint URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#secure_access_cluster_endpoint DynamicSecretGke#secure_access_cluster_endpoint}
    */
    readonly secureAccessClusterEndpoint?: string;
    /**
    * Enable/Disable secure remote access, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#secure_access_enable DynamicSecretGke#secure_access_enable}
    */
    readonly secureAccessEnable?: string;
    /**
    * Enable Web Secure Remote Access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#secure_access_web DynamicSecretGke#secure_access_web}
    */
    readonly secureAccessWeb?: boolean | cdktf.IResolvable;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#tags DynamicSecretGke#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#target_name DynamicSecretGke#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#user_ttl DynamicSecretGke#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke akeyless_dynamic_secret_gke}
*/
export declare class DynamicSecretGke extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_gke";
    /**
    * Generates CDKTF code for importing a DynamicSecretGke resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretGke to import
    * @param importFromId The id of the existing DynamicSecretGke that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretGke to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_gke akeyless_dynamic_secret_gke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretGkeConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretGkeConfig);
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _gkeAccountKey?;
    get gkeAccountKey(): string;
    set gkeAccountKey(value: string);
    resetGkeAccountKey(): void;
    get gkeAccountKeyInput(): string | undefined;
    private _gkeClusterCert?;
    get gkeClusterCert(): string;
    set gkeClusterCert(value: string);
    resetGkeClusterCert(): void;
    get gkeClusterCertInput(): string | undefined;
    private _gkeClusterEndpoint?;
    get gkeClusterEndpoint(): string;
    set gkeClusterEndpoint(value: string);
    resetGkeClusterEndpoint(): void;
    get gkeClusterEndpointInput(): string | undefined;
    private _gkeClusterName?;
    get gkeClusterName(): string;
    set gkeClusterName(value: string);
    resetGkeClusterName(): void;
    get gkeClusterNameInput(): string | undefined;
    private _gkeServiceAccountEmail?;
    get gkeServiceAccountEmail(): string;
    set gkeServiceAccountEmail(value: string);
    resetGkeServiceAccountEmail(): void;
    get gkeServiceAccountEmailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secureAccessAllowPortForwading?;
    get secureAccessAllowPortForwading(): boolean | cdktf.IResolvable;
    set secureAccessAllowPortForwading(value: boolean | cdktf.IResolvable);
    resetSecureAccessAllowPortForwading(): void;
    get secureAccessAllowPortForwadingInput(): boolean | cdktf.IResolvable | undefined;
    private _secureAccessBastionIssuer?;
    get secureAccessBastionIssuer(): string;
    set secureAccessBastionIssuer(value: string);
    resetSecureAccessBastionIssuer(): void;
    get secureAccessBastionIssuerInput(): string | undefined;
    private _secureAccessClusterEndpoint?;
    get secureAccessClusterEndpoint(): string;
    set secureAccessClusterEndpoint(value: string);
    resetSecureAccessClusterEndpoint(): void;
    get secureAccessClusterEndpointInput(): string | undefined;
    private _secureAccessEnable?;
    get secureAccessEnable(): string;
    set secureAccessEnable(value: string);
    resetSecureAccessEnable(): void;
    get secureAccessEnableInput(): string | undefined;
    private _secureAccessWeb?;
    get secureAccessWeb(): boolean | cdktf.IResolvable;
    set secureAccessWeb(value: boolean | cdktf.IResolvable);
    resetSecureAccessWeb(): void;
    get secureAccessWebInput(): boolean | cdktf.IResolvable | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
