import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretCustomConfig extends cdktf.TerraformMetaArguments {
    /**
    * Rotation period in days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#admin_rotation_interval_days DynamicSecretCustom#admin_rotation_interval_days}
    */
    readonly adminRotationIntervalDays?: number;
    /**
    * URL of an endpoint that implements /sync/create method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#create_sync_url DynamicSecretCustom#create_sync_url}
    */
    readonly createSyncUrl: string;
    /**
    * Enable automatic admin credentials rotation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#enable_admin_rotation DynamicSecretCustom#enable_admin_rotation}
    */
    readonly enableAdminRotation?: boolean | cdktf.IResolvable;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#encryption_key_name DynamicSecretCustom#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#id DynamicSecretCustom#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#name DynamicSecretCustom#name}
    */
    readonly name: string;
    /**
    * Secret payload to be sent with each create/revoke webhook request
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#payload DynamicSecretCustom#payload}
    */
    readonly payload?: string;
    /**
    * URL of an endpoint that implements /sync/revoke method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#revoke_sync_url DynamicSecretCustom#revoke_sync_url}
    */
    readonly revokeSyncUrl: string;
    /**
    * URL of an endpoint that implements /sync/rotate method
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#rotate_sync_url DynamicSecretCustom#rotate_sync_url}
    */
    readonly rotateSyncUrl?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#tags DynamicSecretCustom#tags}
    */
    readonly tags?: string[];
    /**
    * Maximum allowed time in seconds for the webhook to return the results
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#timeout_sec DynamicSecretCustom#timeout_sec}
    */
    readonly timeoutSec?: number;
    /**
    * User TTL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#user_ttl DynamicSecretCustom#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom akeyless_dynamic_secret_custom}
*/
export declare class DynamicSecretCustom extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_custom";
    /**
    * Generates CDKTF code for importing a DynamicSecretCustom resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretCustom to import
    * @param importFromId The id of the existing DynamicSecretCustom that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretCustom to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_custom akeyless_dynamic_secret_custom} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretCustomConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretCustomConfig);
    private _adminRotationIntervalDays?;
    get adminRotationIntervalDays(): number;
    set adminRotationIntervalDays(value: number);
    resetAdminRotationIntervalDays(): void;
    get adminRotationIntervalDaysInput(): number | undefined;
    private _createSyncUrl?;
    get createSyncUrl(): string;
    set createSyncUrl(value: string);
    get createSyncUrlInput(): string | undefined;
    private _enableAdminRotation?;
    get enableAdminRotation(): boolean | cdktf.IResolvable;
    set enableAdminRotation(value: boolean | cdktf.IResolvable);
    resetEnableAdminRotation(): void;
    get enableAdminRotationInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _payload?;
    get payload(): string;
    set payload(value: string);
    resetPayload(): void;
    get payloadInput(): string | undefined;
    private _revokeSyncUrl?;
    get revokeSyncUrl(): string;
    set revokeSyncUrl(value: string);
    get revokeSyncUrlInput(): string | undefined;
    private _rotateSyncUrl?;
    get rotateSyncUrl(): string;
    set rotateSyncUrl(value: string);
    resetRotateSyncUrl(): void;
    get rotateSyncUrlInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
