import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicSecretCassandraConfig extends cdktf.TerraformMetaArguments {
    /**
    * Cassandra Creation Statements
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#cassandra_creation_statements DynamicSecretCassandra#cassandra_creation_statements}
    */
    readonly cassandraCreationStatements?: string;
    /**
    * Cassandra hosts names or IP addresses, comma separated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#cassandra_hosts DynamicSecretCassandra#cassandra_hosts}
    */
    readonly cassandraHosts?: string;
    /**
    * Cassandra superuser password
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#cassandra_password DynamicSecretCassandra#cassandra_password}
    */
    readonly cassandraPassword?: string;
    /**
    * Cassandra port
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#cassandra_port DynamicSecretCassandra#cassandra_port}
    */
    readonly cassandraPort?: string;
    /**
    * Cassandra superuser user name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#cassandra_username DynamicSecretCassandra#cassandra_username}
    */
    readonly cassandraUsername?: string;
    /**
    * Customize how temporary usernames are generated using go template
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#custom_username_template DynamicSecretCassandra#custom_username_template}
    */
    readonly customUsernameTemplate?: string;
    /**
    * Encrypt dynamic secret details with following key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#encryption_key_name DynamicSecretCassandra#encryption_key_name}
    */
    readonly encryptionKeyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#id DynamicSecretCassandra#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Dynamic secret name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#name DynamicSecretCassandra#name}
    */
    readonly name: string;
    /**
    * The length of the password to be generated
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#password_length DynamicSecretCassandra#password_length}
    */
    readonly passwordLength?: string;
    /**
    * Enable/Disable SSL [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#ssl DynamicSecretCassandra#ssl}
    */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
    * SSL CA certificate in base64 encoding generated from a trusted Certificate Authority (CA)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#ssl_certificate DynamicSecretCassandra#ssl_certificate}
    */
    readonly sslCertificate?: string;
    /**
    * List of the tags attached to this secret. To specify multiple tags use argument multiple times: -t Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#tags DynamicSecretCassandra#tags}
    */
    readonly tags?: string[];
    /**
    * Name of existing target to use in dynamic secret creation
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#target_name DynamicSecretCassandra#target_name}
    */
    readonly targetName?: string;
    /**
    * User TTL (<=60m for access token)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#user_ttl DynamicSecretCassandra#user_ttl}
    */
    readonly userTtl?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra akeyless_dynamic_secret_cassandra}
*/
export declare class DynamicSecretCassandra extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_dynamic_secret_cassandra";
    /**
    * Generates CDKTF code for importing a DynamicSecretCassandra resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicSecretCassandra to import
    * @param importFromId The id of the existing DynamicSecretCassandra that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicSecretCassandra to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/dynamic_secret_cassandra akeyless_dynamic_secret_cassandra} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicSecretCassandraConfig
    */
    constructor(scope: Construct, id: string, config: DynamicSecretCassandraConfig);
    private _cassandraCreationStatements?;
    get cassandraCreationStatements(): string;
    set cassandraCreationStatements(value: string);
    resetCassandraCreationStatements(): void;
    get cassandraCreationStatementsInput(): string | undefined;
    private _cassandraHosts?;
    get cassandraHosts(): string;
    set cassandraHosts(value: string);
    resetCassandraHosts(): void;
    get cassandraHostsInput(): string | undefined;
    private _cassandraPassword?;
    get cassandraPassword(): string;
    set cassandraPassword(value: string);
    resetCassandraPassword(): void;
    get cassandraPasswordInput(): string | undefined;
    private _cassandraPort?;
    get cassandraPort(): string;
    set cassandraPort(value: string);
    resetCassandraPort(): void;
    get cassandraPortInput(): string | undefined;
    private _cassandraUsername?;
    get cassandraUsername(): string;
    set cassandraUsername(value: string);
    resetCassandraUsername(): void;
    get cassandraUsernameInput(): string | undefined;
    private _customUsernameTemplate?;
    get customUsernameTemplate(): string;
    set customUsernameTemplate(value: string);
    resetCustomUsernameTemplate(): void;
    get customUsernameTemplateInput(): string | undefined;
    private _encryptionKeyName?;
    get encryptionKeyName(): string;
    set encryptionKeyName(value: string);
    resetEncryptionKeyName(): void;
    get encryptionKeyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _passwordLength?;
    get passwordLength(): string;
    set passwordLength(value: string);
    resetPasswordLength(): void;
    get passwordLengthInput(): string | undefined;
    private _ssl?;
    get ssl(): boolean | cdktf.IResolvable;
    set ssl(value: boolean | cdktf.IResolvable);
    resetSsl(): void;
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    private _sslCertificate?;
    get sslCertificate(): string;
    set sslCertificate(value: string);
    resetSslCertificate(): void;
    get sslCertificateInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _targetName?;
    get targetName(): string;
    set targetName(value: string);
    resetTargetName(): void;
    get targetNameInput(): string | undefined;
    private _userTtl?;
    get userTtl(): string;
    set userTtl(value: string);
    resetUserTtl(): void;
    get userTtlInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
