import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessTokenizeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize#id DataAkeylessTokenize#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Data to be encrypted
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize#plaintext DataAkeylessTokenize#plaintext}
    */
    readonly plaintext: string;
    /**
    * The name of the tokenizer to use in the encryption process
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize#tokenizer_name DataAkeylessTokenize#tokenizer_name}
    */
    readonly tokenizerName: string;
    /**
    * Base64 encoded tweak for vaultless encryption
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize#tweak DataAkeylessTokenize#tweak}
    */
    readonly tweak?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize akeyless_tokenize}
*/
export declare class DataAkeylessTokenize extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_tokenize";
    /**
    * Generates CDKTF code for importing a DataAkeylessTokenize resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessTokenize to import
    * @param importFromId The id of the existing DataAkeylessTokenize that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessTokenize to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/tokenize akeyless_tokenize} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessTokenizeConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessTokenizeConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    get result(): string;
    private _tokenizerName?;
    get tokenizerName(): string;
    set tokenizerName(value: string);
    get tokenizerNameInput(): string | undefined;
    private _tweak?;
    get tweak(): string;
    set tweak(value: string);
    resetTweak(): void;
    get tweakInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
