import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessTargetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target#id DataAkeylessTarget#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target#name DataAkeylessTarget#name}
    */
    readonly name: string;
    /**
    * Include all target versions in reply
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target#show_versions DataAkeylessTarget#show_versions}
    */
    readonly showVersions?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target akeyless_target}
*/
export declare class DataAkeylessTarget extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_target";
    /**
    * Generates CDKTF code for importing a DataAkeylessTarget resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessTarget to import
    * @param importFromId The id of the existing DataAkeylessTarget that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessTarget to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/target akeyless_target} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessTargetConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessTargetConfig);
    get clientPermissions(): string[];
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastVersion(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get protectionKeyName(): string;
    private _showVersions?;
    get showVersions(): boolean | cdktf.IResolvable;
    set showVersions(value: boolean | cdktf.IResolvable);
    resetShowVersions(): void;
    get showVersionsInput(): boolean | cdktf.IResolvable | undefined;
    get targetId(): number;
    get targetItemsAssoc(): string;
    get targetName(): string;
    get targetType(): string;
    get targetVersions(): string;
    get withCustomerFragment(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
