import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessPkiCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Subject Alternative Names to be included in the PKI certificate (in a comma-delimited list)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#alt_names DataAkeylessPkiCertificate#alt_names}
    */
    readonly altNames?: string;
    /**
    * The name of the PKI certificate issuer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#cert_issuer_name DataAkeylessPkiCertificate#cert_issuer_name}
    */
    readonly certIssuerName: string;
    /**
    * The common name to be included in the PKI certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#common_name DataAkeylessPkiCertificate#common_name}
    */
    readonly commonName?: string;
    /**
    * Certificate Signing Request contents encoded in base64 to generate the certificate with
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#csr_data_base64 DataAkeylessPkiCertificate#csr_data_base64}
    */
    readonly csrDataBase64?: string;
    /**
    *  A comma-separated list of extended key usage requests which will be used for certificate issuance. Supported values: 'clientauth', 'serverauth'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#extended_key_usage DataAkeylessPkiCertificate#extended_key_usage}
    */
    readonly extendedKeyUsage?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#id DataAkeylessPkiCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * pki key file contents encoded using Base64
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#key_data_base64 DataAkeylessPkiCertificate#key_data_base64}
    */
    readonly keyDataBase64?: string;
    /**
    * Updated certificate lifetime in seconds (must be less than the Certificate Issuer default TTL)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#ttl DataAkeylessPkiCertificate#ttl}
    */
    readonly ttl?: number;
    /**
    * The URI Subject Alternative Names to be included in the PKI certificate (in a comma-delimited list)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#uri_sans DataAkeylessPkiCertificate#uri_sans}
    */
    readonly uriSans?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate akeyless_pki_certificate}
*/
export declare class DataAkeylessPkiCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_pki_certificate";
    /**
    * Generates CDKTF code for importing a DataAkeylessPkiCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessPkiCertificate to import
    * @param importFromId The id of the existing DataAkeylessPkiCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessPkiCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/pki_certificate akeyless_pki_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessPkiCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessPkiCertificateConfig);
    private _altNames?;
    get altNames(): string;
    set altNames(value: string);
    resetAltNames(): void;
    get altNamesInput(): string | undefined;
    get certDisplayId(): string;
    private _certIssuerName?;
    get certIssuerName(): string;
    set certIssuerName(value: string);
    get certIssuerNameInput(): string | undefined;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    resetCommonName(): void;
    get commonNameInput(): string | undefined;
    private _csrDataBase64?;
    get csrDataBase64(): string;
    set csrDataBase64(value: string);
    resetCsrDataBase64(): void;
    get csrDataBase64Input(): string | undefined;
    get data(): string;
    private _extendedKeyUsage?;
    get extendedKeyUsage(): string;
    set extendedKeyUsage(value: string);
    resetExtendedKeyUsage(): void;
    get extendedKeyUsageInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyDataBase64?;
    get keyDataBase64(): string;
    set keyDataBase64(value: string);
    resetKeyDataBase64(): void;
    get keyDataBase64Input(): string | undefined;
    get parentCert(): string;
    get readingToken(): string;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _uriSans?;
    get uriSans(): string;
    set uriSans(value: string);
    resetUriSans(): void;
    get uriSansInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
