import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessCsrConfig extends cdktf.TerraformMetaArguments {
    /**
    * The algorithm (RSA/Elliptic-curve) to use for generating the new key
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#alg DataAkeylessCsr#alg}
    */
    readonly alg?: string;
    /**
    * A comma-separated list of dns alternative names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#alt_names DataAkeylessCsr#alt_names}
    */
    readonly altNames?: string;
    /**
    * The certificate type to be included in the CSR certificate (ssl-client/ssl-server/certificate-signing)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#certificate_type DataAkeylessCsr#certificate_type}
    */
    readonly certificateType?: string;
    /**
    * The city to be included in the CSR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#city DataAkeylessCsr#city}
    */
    readonly city?: string;
    /**
    * The common name to be included in the CSR certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#common_name DataAkeylessCsr#common_name}
    */
    readonly commonName: string;
    /**
    * The country to be included in the CSR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#country DataAkeylessCsr#country}
    */
    readonly country?: string;
    /**
    * Add critical to the key usage extension (will be false if not added)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#critical DataAkeylessCsr#critical}
    */
    readonly critical?: boolean | cdktf.IResolvable;
    /**
    * The department to be included in the CSR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#dep DataAkeylessCsr#dep}
    */
    readonly dep?: string;
    /**
    * A comma-separated list of email addresses alternative names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#email_addresses DataAkeylessCsr#email_addresses}
    */
    readonly emailAddresses?: string;
    /**
    * Generate a new classic key for the csr
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#generate_key DataAkeylessCsr#generate_key}
    */
    readonly generateKey?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#id DataAkeylessCsr#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A comma-separated list of ip addresses alternative names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#ip_addresses DataAkeylessCsr#ip_addresses}
    */
    readonly ipAddresses?: string;
    /**
    * The type of the key to generate (classic-key/dfc)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#key_type DataAkeylessCsr#key_type}
    */
    readonly keyType?: string;
    /**
    * The classic key name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#name DataAkeylessCsr#name}
    */
    readonly name: string;
    /**
    * The organization to be included in the CSR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#org DataAkeylessCsr#org}
    */
    readonly org?: string;
    /**
    * The number of fragments that the item will be split into (not includes customer fragment, relevant only for dfc keys)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#split_level DataAkeylessCsr#split_level}
    */
    readonly splitLevel?: number;
    /**
    * The state to be included in the CSR
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#state DataAkeylessCsr#state}
    */
    readonly state?: string;
    /**
    * A comma-separated list of uri alternative names
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#uri_sans DataAkeylessCsr#uri_sans}
    */
    readonly uriSans?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr akeyless_csr}
*/
export declare class DataAkeylessCsr extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_csr";
    /**
    * Generates CDKTF code for importing a DataAkeylessCsr resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessCsr to import
    * @param importFromId The id of the existing DataAkeylessCsr that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessCsr to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/csr akeyless_csr} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessCsrConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessCsrConfig);
    private _alg?;
    get alg(): string;
    set alg(value: string);
    resetAlg(): void;
    get algInput(): string | undefined;
    private _altNames?;
    get altNames(): string;
    set altNames(value: string);
    resetAltNames(): void;
    get altNamesInput(): string | undefined;
    private _certificateType?;
    get certificateType(): string;
    set certificateType(value: string);
    resetCertificateType(): void;
    get certificateTypeInput(): string | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    resetCity(): void;
    get cityInput(): string | undefined;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    resetCritical(): void;
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    get data(): string;
    private _dep?;
    get dep(): string;
    set dep(value: string);
    resetDep(): void;
    get depInput(): string | undefined;
    private _emailAddresses?;
    get emailAddresses(): string;
    set emailAddresses(value: string);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string | undefined;
    private _generateKey?;
    get generateKey(): boolean | cdktf.IResolvable;
    set generateKey(value: boolean | cdktf.IResolvable);
    resetGenerateKey(): void;
    get generateKeyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ipAddresses?;
    get ipAddresses(): string;
    set ipAddresses(value: string);
    resetIpAddresses(): void;
    get ipAddressesInput(): string | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _org?;
    get org(): string;
    set org(value: string);
    resetOrg(): void;
    get orgInput(): string | undefined;
    private _splitLevel?;
    get splitLevel(): number;
    set splitLevel(value: number);
    resetSplitLevel(): void;
    get splitLevelInput(): number | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _uriSans?;
    get uriSans(): string;
    set uriSans(value: string);
    resetUriSans(): void;
    get uriSansInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
