import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAkeylessAuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth_method#id DataAkeylessAuthMethod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The path where the secret is stored. Defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth_method#path DataAkeylessAuthMethod#path}
    */
    readonly path: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth_method akeyless_auth_method}
*/
export declare class DataAkeylessAuthMethod extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "akeyless_auth_method";
    /**
    * Generates CDKTF code for importing a DataAkeylessAuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAkeylessAuthMethod to import
    * @param importFromId The id of the existing DataAkeylessAuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAkeylessAuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/data-sources/auth_method akeyless_auth_method} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAkeylessAuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: DataAkeylessAuthMethodConfig);
    get accessId(): string;
    get accountId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
