import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Content of the certificate in a Base64 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#certificate_data Certificate#certificate_data}
    */
    readonly certificateData?: string;
    /**
    * Protection from accidental deletion of this object, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#delete_protection Certificate#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * Description of the object
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#description Certificate#description}
    */
    readonly description?: string;
    /**
    * How many days before the expiration of the certificate would you like to be notified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#expiration_event_in Certificate#expiration_event_in}
    */
    readonly expirationEventIn?: string[];
    /**
    * CertificateFormat of the certificate and private key, possible values: cer,crt,pem,pfx,p12.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#format Certificate#format}
    */
    readonly format?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#id Certificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of a key to use to encrypt the certificate's key (if empty, the account default protectionKey key will be used)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#key Certificate#key}
    */
    readonly key?: string;
    /**
    * Content of the certificate's private key in a Base64 format.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#key_data Certificate#key_data}
    */
    readonly keyData?: string;
    /**
    * Certificate name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#name Certificate#name}
    */
    readonly name: string;
    /**
    * Add tags attached to this object. To specify multiple tags use argument multiple times: --tag Tag1 -t Tag2
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#tags Certificate#tags}
    */
    readonly tags?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate akeyless_certificate}
*/
export declare class Certificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_certificate";
    /**
    * Generates CDKTF code for importing a Certificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Certificate to import
    * @param importFromId The id of the existing Certificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Certificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/certificate akeyless_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateConfig
    */
    constructor(scope: Construct, id: string, config: CertificateConfig);
    private _certificateData?;
    get certificateData(): string;
    set certificateData(value: string);
    resetCertificateData(): void;
    get certificateDataInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expirationEventIn?;
    get expirationEventIn(): string[];
    set expirationEventIn(value: string[]);
    resetExpirationEventIn(): void;
    get expirationEventInInput(): string[] | undefined;
    private _format?;
    get format(): string;
    set format(value: string);
    resetFormat(): void;
    get formatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _keyData?;
    get keyData(): string;
    set keyData(value: string);
    resetKeyData(): void;
    get keyDataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
