import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#access_expires AuthMethod#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_ips AuthMethod#bound_ips}
    */
    readonly boundIps?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#id AuthMethod#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The path where the Auth Method will be stored
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#path AuthMethod#path}
    */
    readonly path: string;
    /**
    * api_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#api_key AuthMethod#api_key}
    */
    readonly apiKey?: AuthMethodApiKey[] | cdktf.IResolvable;
    /**
    * aws_iam block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#aws_iam AuthMethod#aws_iam}
    */
    readonly awsIam?: AuthMethodAwsIam[] | cdktf.IResolvable;
    /**
    * azure_ad block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#azure_ad AuthMethod#azure_ad}
    */
    readonly azureAd?: AuthMethodAzureAd[] | cdktf.IResolvable;
    /**
    * gcp block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#gcp AuthMethod#gcp}
    */
    readonly gcp?: AuthMethodGcp[] | cdktf.IResolvable;
    /**
    * saml block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#saml AuthMethod#saml}
    */
    readonly saml?: AuthMethodSaml[] | cdktf.IResolvable;
}
export interface AuthMethodApiKey {
}
export declare function authMethodApiKeyToTerraform(struct?: AuthMethodApiKey | cdktf.IResolvable): any;
export declare function authMethodApiKeyToHclTerraform(struct?: AuthMethodApiKey | cdktf.IResolvable): any;
export declare class AuthMethodApiKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodApiKey | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodApiKey | cdktf.IResolvable | undefined);
}
export declare class AuthMethodApiKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodApiKey[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodApiKeyOutputReference;
}
export interface AuthMethodAwsIam {
    /**
    * A list of full arns that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_arn AuthMethod#bound_arn}
    */
    readonly boundArn?: string[];
    /**
    * A list of AWS account-IDs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_aws_account_id AuthMethod#bound_aws_account_id}
    */
    readonly boundAwsAccountId: string[];
    /**
    * A list of full resource ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_resource_id AuthMethod#bound_resource_id}
    */
    readonly boundResourceId?: string[];
    /**
    * A list of full role ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_role_id AuthMethod#bound_role_id}
    */
    readonly boundRoleId?: string[];
    /**
    * A list of full role-name that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_role_name AuthMethod#bound_role_name}
    */
    readonly boundRoleName?: string[];
    /**
    * A list of full user ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_user_id AuthMethod#bound_user_id}
    */
    readonly boundUserId?: string[];
    /**
    * A list of full user-name that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_user_name AuthMethod#bound_user_name}
    */
    readonly boundUserName?: string[];
    /**
    * STS URL (default: https://sts.amazonaws.com)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#sts_url AuthMethod#sts_url}
    */
    readonly stsUrl?: string;
}
export declare function authMethodAwsIamToTerraform(struct?: AuthMethodAwsIam | cdktf.IResolvable): any;
export declare function authMethodAwsIamToHclTerraform(struct?: AuthMethodAwsIam | cdktf.IResolvable): any;
export declare class AuthMethodAwsIamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodAwsIam | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodAwsIam | cdktf.IResolvable | undefined);
    private _boundArn?;
    get boundArn(): string[];
    set boundArn(value: string[]);
    resetBoundArn(): void;
    get boundArnInput(): string[] | undefined;
    private _boundAwsAccountId?;
    get boundAwsAccountId(): string[];
    set boundAwsAccountId(value: string[]);
    get boundAwsAccountIdInput(): string[] | undefined;
    private _boundResourceId?;
    get boundResourceId(): string[];
    set boundResourceId(value: string[]);
    resetBoundResourceId(): void;
    get boundResourceIdInput(): string[] | undefined;
    private _boundRoleId?;
    get boundRoleId(): string[];
    set boundRoleId(value: string[]);
    resetBoundRoleId(): void;
    get boundRoleIdInput(): string[] | undefined;
    private _boundRoleName?;
    get boundRoleName(): string[];
    set boundRoleName(value: string[]);
    resetBoundRoleName(): void;
    get boundRoleNameInput(): string[] | undefined;
    private _boundUserId?;
    get boundUserId(): string[];
    set boundUserId(value: string[]);
    resetBoundUserId(): void;
    get boundUserIdInput(): string[] | undefined;
    private _boundUserName?;
    get boundUserName(): string[];
    set boundUserName(value: string[]);
    resetBoundUserName(): void;
    get boundUserNameInput(): string[] | undefined;
    private _stsUrl?;
    get stsUrl(): string;
    set stsUrl(value: string);
    resetStsUrl(): void;
    get stsUrlInput(): string | undefined;
}
export declare class AuthMethodAwsIamList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodAwsIam[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodAwsIamOutputReference;
}
export interface AuthMethodAzureAd {
    /**
    * A list of group ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_group_id AuthMethod#bound_group_id}
    */
    readonly boundGroupId?: string[];
    /**
    * A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_providers AuthMethod#bound_providers}
    */
    readonly boundProviders?: string[];
    /**
    * A list of full resource ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_resource_id AuthMethod#bound_resource_id}
    */
    readonly boundResourceId?: string[];
    /**
    * A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_resource_names AuthMethod#bound_resource_names}
    */
    readonly boundResourceNames?: string[];
    /**
    * A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_resource_types AuthMethod#bound_resource_types}
    */
    readonly boundResourceTypes?: string[];
    /**
    * A list of resource groups that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_rg_id AuthMethod#bound_rg_id}
    */
    readonly boundRgId?: string[];
    /**
    * A list of service principal IDs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_spid AuthMethod#bound_spid}
    */
    readonly boundSpid?: string[];
    /**
    * A list of subscription ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_sub_id AuthMethod#bound_sub_id}
    */
    readonly boundSubId?: string[];
    /**
    * The Azure tenant id that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_tenant_id AuthMethod#bound_tenant_id}
    */
    readonly boundTenantId: string;
    /**
    * The audience in the JWT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#custom_audience AuthMethod#custom_audience}
    */
    readonly customAudience?: string;
    /**
    * Issuer URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#custom_issuer AuthMethod#custom_issuer}
    */
    readonly customIssuer?: string;
    /**
    * The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#jwks_uri AuthMethod#jwks_uri}
    */
    readonly jwksUri?: string;
}
export declare function authMethodAzureAdToTerraform(struct?: AuthMethodAzureAd | cdktf.IResolvable): any;
export declare function authMethodAzureAdToHclTerraform(struct?: AuthMethodAzureAd | cdktf.IResolvable): any;
export declare class AuthMethodAzureAdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodAzureAd | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodAzureAd | cdktf.IResolvable | undefined);
    private _boundGroupId?;
    get boundGroupId(): string[];
    set boundGroupId(value: string[]);
    resetBoundGroupId(): void;
    get boundGroupIdInput(): string[] | undefined;
    private _boundProviders?;
    get boundProviders(): string[];
    set boundProviders(value: string[]);
    resetBoundProviders(): void;
    get boundProvidersInput(): string[] | undefined;
    private _boundResourceId?;
    get boundResourceId(): string[];
    set boundResourceId(value: string[]);
    resetBoundResourceId(): void;
    get boundResourceIdInput(): string[] | undefined;
    private _boundResourceNames?;
    get boundResourceNames(): string[];
    set boundResourceNames(value: string[]);
    resetBoundResourceNames(): void;
    get boundResourceNamesInput(): string[] | undefined;
    private _boundResourceTypes?;
    get boundResourceTypes(): string[];
    set boundResourceTypes(value: string[]);
    resetBoundResourceTypes(): void;
    get boundResourceTypesInput(): string[] | undefined;
    private _boundRgId?;
    get boundRgId(): string[];
    set boundRgId(value: string[]);
    resetBoundRgId(): void;
    get boundRgIdInput(): string[] | undefined;
    private _boundSpid?;
    get boundSpid(): string[];
    set boundSpid(value: string[]);
    resetBoundSpid(): void;
    get boundSpidInput(): string[] | undefined;
    private _boundSubId?;
    get boundSubId(): string[];
    set boundSubId(value: string[]);
    resetBoundSubId(): void;
    get boundSubIdInput(): string[] | undefined;
    private _boundTenantId?;
    get boundTenantId(): string;
    set boundTenantId(value: string);
    get boundTenantIdInput(): string | undefined;
    private _customAudience?;
    get customAudience(): string;
    set customAudience(value: string);
    resetCustomAudience(): void;
    get customAudienceInput(): string | undefined;
    private _customIssuer?;
    get customIssuer(): string;
    set customIssuer(value: string);
    resetCustomIssuer(): void;
    get customIssuerInput(): string | undefined;
    private _jwksUri?;
    get jwksUri(): string;
    set jwksUri(value: string);
    resetJwksUri(): void;
    get jwksUriInput(): string | undefined;
}
export declare class AuthMethodAzureAdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodAzureAd[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodAzureAdOutputReference;
}
export interface AuthMethodGcpGce {
    /**
    * GCE only. A list of GCP labels formatted as "key:value" pairs that must be set on instances in order to authenticate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_labels AuthMethod#bound_labels}
    */
    readonly boundLabels?: string[];
    /**
    * GCE only. A list of regions. GCE instances must belong to any of the provided regions in order to authenticate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_regions AuthMethod#bound_regions}
    */
    readonly boundRegions?: string[];
    /**
    * GCE only. A list of zones. GCE instances must belong to any of the provided zones in order to authenticate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_zones AuthMethod#bound_zones}
    */
    readonly boundZones?: string[];
}
export declare function authMethodGcpGceToTerraform(struct?: AuthMethodGcpGce | cdktf.IResolvable): any;
export declare function authMethodGcpGceToHclTerraform(struct?: AuthMethodGcpGce | cdktf.IResolvable): any;
export declare class AuthMethodGcpGceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodGcpGce | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodGcpGce | cdktf.IResolvable | undefined);
    private _boundLabels?;
    get boundLabels(): string[];
    set boundLabels(value: string[]);
    resetBoundLabels(): void;
    get boundLabelsInput(): string[] | undefined;
    private _boundRegions?;
    get boundRegions(): string[];
    set boundRegions(value: string[]);
    resetBoundRegions(): void;
    get boundRegionsInput(): string[] | undefined;
    private _boundZones?;
    get boundZones(): string[];
    set boundZones(value: string[]);
    resetBoundZones(): void;
    get boundZonesInput(): string[] | undefined;
}
export declare class AuthMethodGcpGceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodGcpGce[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodGcpGceOutputReference;
}
export interface AuthMethodGcpIam {
    /**
    * IAM only. A list of Service Accounts. Clients must belong to any of the provided service accounts in order to authenticate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#bound_service_accounts AuthMethod#bound_service_accounts}
    */
    readonly boundServiceAccounts?: string[];
}
export declare function authMethodGcpIamToTerraform(struct?: AuthMethodGcpIam | cdktf.IResolvable): any;
export declare function authMethodGcpIamToHclTerraform(struct?: AuthMethodGcpIam | cdktf.IResolvable): any;
export declare class AuthMethodGcpIamOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodGcpIam | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodGcpIam | cdktf.IResolvable | undefined);
    private _boundServiceAccounts?;
    get boundServiceAccounts(): string[];
    set boundServiceAccounts(value: string[]);
    resetBoundServiceAccounts(): void;
    get boundServiceAccountsInput(): string[] | undefined;
}
export declare class AuthMethodGcpIamList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodGcpIam[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodGcpIamOutputReference;
}
export interface AuthMethodGcp {
    /**
    * The audience to verify in the JWT received by the client
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#audience AuthMethod#audience}
    */
    readonly audience?: string;
    /**
    * Service Account creds data, base64 encoded
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#service_account_creds_data AuthMethod#service_account_creds_data}
    */
    readonly serviceAccountCredsData: string;
    /**
    * gce block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#gce AuthMethod#gce}
    */
    readonly gce?: AuthMethodGcpGce[] | cdktf.IResolvable;
    /**
    * iam block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#iam AuthMethod#iam}
    */
    readonly iam?: AuthMethodGcpIam[] | cdktf.IResolvable;
}
export declare function authMethodGcpToTerraform(struct?: AuthMethodGcp | cdktf.IResolvable): any;
export declare function authMethodGcpToHclTerraform(struct?: AuthMethodGcp | cdktf.IResolvable): any;
export declare class AuthMethodGcpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodGcp | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodGcp | cdktf.IResolvable | undefined);
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _serviceAccountCredsData?;
    get serviceAccountCredsData(): string;
    set serviceAccountCredsData(value: string);
    get serviceAccountCredsDataInput(): string | undefined;
    private _gce;
    get gce(): AuthMethodGcpGceList;
    putGce(value: AuthMethodGcpGce[] | cdktf.IResolvable): void;
    resetGce(): void;
    get gceInput(): cdktf.IResolvable | AuthMethodGcpGce[] | undefined;
    private _iam;
    get iam(): AuthMethodGcpIamList;
    putIam(value: AuthMethodGcpIam[] | cdktf.IResolvable): void;
    resetIam(): void;
    get iamInput(): cdktf.IResolvable | AuthMethodGcpIam[] | undefined;
}
export declare class AuthMethodGcpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodGcp[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodGcpOutputReference;
}
export interface AuthMethodSaml {
    /**
    * IDP metadata url
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#idp_metadata_url AuthMethod#idp_metadata_url}
    */
    readonly idpMetadataUrl?: string;
    /**
    * IDP metadata xml data
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#idp_metadata_xml_data AuthMethod#idp_metadata_xml_data}
    */
    readonly idpMetadataXmlData?: string;
    /**
    * A unique identifier (ID) value should be configured for OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#unique_identifier AuthMethod#unique_identifier}
    */
    readonly uniqueIdentifier: string;
}
export declare function authMethodSamlToTerraform(struct?: AuthMethodSaml | cdktf.IResolvable): any;
export declare function authMethodSamlToHclTerraform(struct?: AuthMethodSaml | cdktf.IResolvable): any;
export declare class AuthMethodSamlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AuthMethodSaml | cdktf.IResolvable | undefined;
    set internalValue(value: AuthMethodSaml | cdktf.IResolvable | undefined);
    private _idpMetadataUrl?;
    get idpMetadataUrl(): string;
    set idpMetadataUrl(value: string);
    resetIdpMetadataUrl(): void;
    get idpMetadataUrlInput(): string | undefined;
    private _idpMetadataXmlData?;
    get idpMetadataXmlData(): string;
    set idpMetadataXmlData(value: string);
    resetIdpMetadataXmlData(): void;
    get idpMetadataXmlDataInput(): string | undefined;
    private _uniqueIdentifier?;
    get uniqueIdentifier(): string;
    set uniqueIdentifier(value: string);
    get uniqueIdentifierInput(): string | undefined;
}
export declare class AuthMethodSamlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AuthMethodSaml[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AuthMethodSamlOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method akeyless_auth_method}
*/
export declare class AuthMethod extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method";
    /**
    * Generates CDKTF code for importing a AuthMethod resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethod to import
    * @param importFromId The id of the existing AuthMethod that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethod to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method akeyless_auth_method} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    get accessKey(): string;
    private _boundIps?;
    get boundIps(): string;
    set boundIps(value: string);
    resetBoundIps(): void;
    get boundIpsInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _apiKey;
    get apiKey(): AuthMethodApiKeyList;
    putApiKey(value: AuthMethodApiKey[] | cdktf.IResolvable): void;
    resetApiKey(): void;
    get apiKeyInput(): cdktf.IResolvable | AuthMethodApiKey[] | undefined;
    private _awsIam;
    get awsIam(): AuthMethodAwsIamList;
    putAwsIam(value: AuthMethodAwsIam[] | cdktf.IResolvable): void;
    resetAwsIam(): void;
    get awsIamInput(): cdktf.IResolvable | AuthMethodAwsIam[] | undefined;
    private _azureAd;
    get azureAd(): AuthMethodAzureAdList;
    putAzureAd(value: AuthMethodAzureAd[] | cdktf.IResolvable): void;
    resetAzureAd(): void;
    get azureAdInput(): cdktf.IResolvable | AuthMethodAzureAd[] | undefined;
    private _gcp;
    get gcp(): AuthMethodGcpList;
    putGcp(value: AuthMethodGcp[] | cdktf.IResolvable): void;
    resetGcp(): void;
    get gcpInput(): cdktf.IResolvable | AuthMethodGcp[] | undefined;
    private _saml;
    get saml(): AuthMethodSamlList;
    putSaml(value: AuthMethodSaml[] | cdktf.IResolvable): void;
    resetSaml(): void;
    get samlInput(): cdktf.IResolvable | AuthMethodSaml[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
