import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodSamlAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#access_expires AuthMethodSamlA#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * Allowed redirect URIs after the authentication (default is https://console.akeyless.io/login-saml to enable SAML via Akeyless Console and  http://127.0.0.1:* to enable SAML via akeyless CLI)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#allowed_redirect_uri AuthMethodSamlA#allowed_redirect_uri}
    */
    readonly allowedRedirectUri?: string[];
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#audit_logs_claims AuthMethodSamlA#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#bound_ips AuthMethodSamlA#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#delete_protection AuthMethodSamlA#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#force_sub_claims AuthMethodSamlA#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#id AuthMethodSamlA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * IDP metadata url
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#idp_metadata_url AuthMethodSamlA#idp_metadata_url}
    */
    readonly idpMetadataUrl?: string;
    /**
    * IDP metadata xml data for saml authentication
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#idp_metadata_xml_data AuthMethodSamlA#idp_metadata_xml_data}
    */
    readonly idpMetadataXmlData?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#jwt_ttl AuthMethodSamlA#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#name AuthMethodSamlA#name}
    */
    readonly name: string;
    /**
    * A unique identifier (ID) value should be configured for OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a sub claim that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#unique_identifier AuthMethodSamlA#unique_identifier}
    */
    readonly uniqueIdentifier: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml akeyless_auth_method_saml}
*/
export declare class AuthMethodSamlA extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_saml";
    /**
    * Generates CDKTF code for importing a AuthMethodSamlA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodSamlA to import
    * @param importFromId The id of the existing AuthMethodSamlA that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodSamlA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_saml akeyless_auth_method_saml} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodSamlAConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodSamlAConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _allowedRedirectUri?;
    get allowedRedirectUri(): string[];
    set allowedRedirectUri(value: string[]);
    resetAllowedRedirectUri(): void;
    get allowedRedirectUriInput(): string[] | undefined;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idpMetadataUrl?;
    get idpMetadataUrl(): string;
    set idpMetadataUrl(value: string);
    resetIdpMetadataUrl(): void;
    get idpMetadataUrlInput(): string | undefined;
    private _idpMetadataXmlData?;
    get idpMetadataXmlData(): string;
    set idpMetadataXmlData(value: string);
    resetIdpMetadataXmlData(): void;
    get idpMetadataXmlDataInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _uniqueIdentifier?;
    get uniqueIdentifier(): string;
    set uniqueIdentifier(value: string);
    get uniqueIdentifierInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
