import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#access_expires AuthMethodCert#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#audit_logs_claims AuthMethodCert#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A list of names. At least one must exist in the Common Name. Supports globbing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_common_names AuthMethodCert#bound_common_names}
    */
    readonly boundCommonNames?: string[];
    /**
    * A list of DNS names. At least one must exist in the SANs. Supports globbing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_dns_sans AuthMethodCert#bound_dns_sans}
    */
    readonly boundDnsSans?: string[];
    /**
    * A list of Email Addresses. At least one must exist in the SANs. Supports globbing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_email_sans AuthMethodCert#bound_email_sans}
    */
    readonly boundEmailSans?: string[];
    /**
    * A list of extensions formatted as 'oid:value'. Expects the extension value to be some type of ASN1 encoded string. All values much match. Supports globbing on 'value'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_extensions AuthMethodCert#bound_extensions}
    */
    readonly boundExtensions?: string[];
    /**
    * A comma-separated CIDR block list to allow client access
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_ips AuthMethodCert#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * A list of Organizational Units names. At least one must exist in the OU field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_organizational_units AuthMethodCert#bound_organizational_units}
    */
    readonly boundOrganizationalUnits?: string[];
    /**
    * A list of URIs. At least one must exist in the SANs. Supports globbing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#bound_uri_sans AuthMethodCert#bound_uri_sans}
    */
    readonly boundUriSans?: string[];
    /**
    * The certificate data in base64, if no file was provided.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#certificate_data AuthMethodCert#certificate_data}
    */
    readonly certificateData?: string;
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#delete_protection AuthMethodCert#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#force_sub_claims AuthMethodCert#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * A comma-separated CIDR block list as a trusted Gateway entity
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#gw_bound_ips AuthMethodCert#gw_bound_ips}
    */
    readonly gwBoundIps?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#id AuthMethodCert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#jwt_ttl AuthMethodCert#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#name AuthMethodCert#name}
    */
    readonly name: string;
    /**
    * A list of revoked cert ids
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#revoked_cert_ids AuthMethodCert#revoked_cert_ids}
    */
    readonly revokedCertIds?: string[];
    /**
    * A unique identifier (ID) value should be configured for OIDC, OAuth2, LDAP and SAML authentication method types and is usually a value such as the email, username, or upn for example. Whenever a user logs in with a token, these authentication types issue a sub claim that contains details uniquely identifying that user. This sub claim includes a key containing the ID value that you configured, and is used to distinguish between different users from within the same organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#unique_identifier AuthMethodCert#unique_identifier}
    */
    readonly uniqueIdentifier: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert akeyless_auth_method_cert}
*/
export declare class AuthMethodCert extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_cert";
    /**
    * Generates CDKTF code for importing a AuthMethodCert resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodCert to import
    * @param importFromId The id of the existing AuthMethodCert that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodCert to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_cert akeyless_auth_method_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodCertConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodCertConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundCommonNames?;
    get boundCommonNames(): string[];
    set boundCommonNames(value: string[]);
    resetBoundCommonNames(): void;
    get boundCommonNamesInput(): string[] | undefined;
    private _boundDnsSans?;
    get boundDnsSans(): string[];
    set boundDnsSans(value: string[]);
    resetBoundDnsSans(): void;
    get boundDnsSansInput(): string[] | undefined;
    private _boundEmailSans?;
    get boundEmailSans(): string[];
    set boundEmailSans(value: string[]);
    resetBoundEmailSans(): void;
    get boundEmailSansInput(): string[] | undefined;
    private _boundExtensions?;
    get boundExtensions(): string[];
    set boundExtensions(value: string[]);
    resetBoundExtensions(): void;
    get boundExtensionsInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _boundOrganizationalUnits?;
    get boundOrganizationalUnits(): string[];
    set boundOrganizationalUnits(value: string[]);
    resetBoundOrganizationalUnits(): void;
    get boundOrganizationalUnitsInput(): string[] | undefined;
    private _boundUriSans?;
    get boundUriSans(): string[];
    set boundUriSans(value: string[]);
    resetBoundUriSans(): void;
    get boundUriSansInput(): string[] | undefined;
    private _certificateData?;
    get certificateData(): string;
    set certificateData(value: string);
    resetCertificateData(): void;
    get certificateDataInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _gwBoundIps?;
    get gwBoundIps(): string[];
    set gwBoundIps(value: string[]);
    resetGwBoundIps(): void;
    get gwBoundIpsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _revokedCertIds?;
    get revokedCertIds(): string[];
    set revokedCertIds(value: string[]);
    resetRevokedCertIds(): void;
    get revokedCertIdsInput(): string[] | undefined;
    private _uniqueIdentifier?;
    get uniqueIdentifier(): string;
    set uniqueIdentifier(value: string);
    get uniqueIdentifierInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
