import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthMethodAzureAdAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Access expiration date in Unix timestamp (select 0 for access without expiry date)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#access_expires AuthMethodAzureAdA#access_expires}
    */
    readonly accessExpires?: number;
    /**
    * The audience in the JWT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#audience AuthMethodAzureAdA#audience}
    */
    readonly audience?: string;
    /**
    * Subclaims to include in audit logs
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#audit_logs_claims AuthMethodAzureAdA#audit_logs_claims}
    */
    readonly auditLogsClaims?: string[];
    /**
    * A list of group ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_group_id AuthMethodAzureAdA#bound_group_id}
    */
    readonly boundGroupId?: string[];
    /**
    * A CIDR whitelist with the IPs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_ips AuthMethodAzureAdA#bound_ips}
    */
    readonly boundIps?: string[];
    /**
    * A list of resource providers that the access is restricted to (e.g, Microsoft.Compute, Microsoft.ManagedIdentity, etc)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_providers AuthMethodAzureAdA#bound_providers}
    */
    readonly boundProviders?: string[];
    /**
    * A list of full resource ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_resource_id AuthMethodAzureAdA#bound_resource_id}
    */
    readonly boundResourceId?: string[];
    /**
    * A list of resource names that the access is restricted to (e.g, a virtual machine name, scale set name, etc).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_resource_names AuthMethodAzureAdA#bound_resource_names}
    */
    readonly boundResourceNames?: string[];
    /**
    * A list of resource types that the access is restricted to (e.g, virtualMachines, userAssignedIdentities, etc)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_resource_types AuthMethodAzureAdA#bound_resource_types}
    */
    readonly boundResourceTypes?: string[];
    /**
    * A list of resource groups that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_rg_id AuthMethodAzureAdA#bound_rg_id}
    */
    readonly boundRgId?: string[];
    /**
    * A list of service principal IDs that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_spid AuthMethodAzureAdA#bound_spid}
    */
    readonly boundSpid?: string[];
    /**
    * A list of subscription ids that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_sub_id AuthMethodAzureAdA#bound_sub_id}
    */
    readonly boundSubId?: string[];
    /**
    * The Azure tenant id that the access is restricted to
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#bound_tenant_id AuthMethodAzureAdA#bound_tenant_id}
    */
    readonly boundTenantId: string;
    /**
    * Protection from accidental deletion of this auth method, [true/false]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#delete_protection AuthMethodAzureAdA#delete_protection}
    */
    readonly deleteProtection?: string;
    /**
    * enforce role-association must include sub claims
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#force_sub_claims AuthMethodAzureAdA#force_sub_claims}
    */
    readonly forceSubClaims?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#id AuthMethodAzureAdA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Issuer URL
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#issuer AuthMethodAzureAdA#issuer}
    */
    readonly issuer?: string;
    /**
    * The URL to the JSON Web Key Set (JWKS) that containing the public keys that should be used to verify any JSON Web Token (JWT) issued by the authorization server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#jwks_uri AuthMethodAzureAdA#jwks_uri}
    */
    readonly jwksUri?: string;
    /**
    * Creds expiration time in minutes
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#jwt_ttl AuthMethodAzureAdA#jwt_ttl}
    */
    readonly jwtTtl?: number;
    /**
    * Auth Method name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#name AuthMethodAzureAdA#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad akeyless_auth_method_azure_ad}
*/
export declare class AuthMethodAzureAdA extends cdktf.TerraformResource {
    static readonly tfResourceType = "akeyless_auth_method_azure_ad";
    /**
    * Generates CDKTF code for importing a AuthMethodAzureAdA resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AuthMethodAzureAdA to import
    * @param importFromId The id of the existing AuthMethodAzureAdA that should be imported. Refer to the {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AuthMethodAzureAdA to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/akeyless-community/akeyless/1.11.2/docs/resources/auth_method_azure_ad akeyless_auth_method_azure_ad} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthMethodAzureAdAConfig
    */
    constructor(scope: Construct, id: string, config: AuthMethodAzureAdAConfig);
    private _accessExpires?;
    get accessExpires(): number;
    set accessExpires(value: number);
    resetAccessExpires(): void;
    get accessExpiresInput(): number | undefined;
    get accessId(): string;
    private _audience?;
    get audience(): string;
    set audience(value: string);
    resetAudience(): void;
    get audienceInput(): string | undefined;
    private _auditLogsClaims?;
    get auditLogsClaims(): string[];
    set auditLogsClaims(value: string[]);
    resetAuditLogsClaims(): void;
    get auditLogsClaimsInput(): string[] | undefined;
    private _boundGroupId?;
    get boundGroupId(): string[];
    set boundGroupId(value: string[]);
    resetBoundGroupId(): void;
    get boundGroupIdInput(): string[] | undefined;
    private _boundIps?;
    get boundIps(): string[];
    set boundIps(value: string[]);
    resetBoundIps(): void;
    get boundIpsInput(): string[] | undefined;
    private _boundProviders?;
    get boundProviders(): string[];
    set boundProviders(value: string[]);
    resetBoundProviders(): void;
    get boundProvidersInput(): string[] | undefined;
    private _boundResourceId?;
    get boundResourceId(): string[];
    set boundResourceId(value: string[]);
    resetBoundResourceId(): void;
    get boundResourceIdInput(): string[] | undefined;
    private _boundResourceNames?;
    get boundResourceNames(): string[];
    set boundResourceNames(value: string[]);
    resetBoundResourceNames(): void;
    get boundResourceNamesInput(): string[] | undefined;
    private _boundResourceTypes?;
    get boundResourceTypes(): string[];
    set boundResourceTypes(value: string[]);
    resetBoundResourceTypes(): void;
    get boundResourceTypesInput(): string[] | undefined;
    private _boundRgId?;
    get boundRgId(): string[];
    set boundRgId(value: string[]);
    resetBoundRgId(): void;
    get boundRgIdInput(): string[] | undefined;
    private _boundSpid?;
    get boundSpid(): string[];
    set boundSpid(value: string[]);
    resetBoundSpid(): void;
    get boundSpidInput(): string[] | undefined;
    private _boundSubId?;
    get boundSubId(): string[];
    set boundSubId(value: string[]);
    resetBoundSubId(): void;
    get boundSubIdInput(): string[] | undefined;
    private _boundTenantId?;
    get boundTenantId(): string;
    set boundTenantId(value: string);
    get boundTenantIdInput(): string | undefined;
    private _deleteProtection?;
    get deleteProtection(): string;
    set deleteProtection(value: string);
    resetDeleteProtection(): void;
    get deleteProtectionInput(): string | undefined;
    private _forceSubClaims?;
    get forceSubClaims(): boolean | cdktf.IResolvable;
    set forceSubClaims(value: boolean | cdktf.IResolvable);
    resetForceSubClaims(): void;
    get forceSubClaimsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _jwksUri?;
    get jwksUri(): string;
    set jwksUri(value: string);
    resetJwksUri(): void;
    get jwksUriInput(): string | undefined;
    private _jwtTtl?;
    get jwtTtl(): number;
    set jwtTtl(value: number);
    resetJwtTtl(): void;
    get jwtTtlInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
