# Generated by Django 3.1.6 on 2021-02-16 19:42

from django.db import migrations, models
import multiselectfield.db.fields


class Migration(migrations.Migration):

    dependencies = [
        ("structures", "0017_war_dec_notifications"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="notification",
            name="notification_type",
        ),
        migrations.RemoveField(
            model_name="webhook",
            name="notification_types",
        ),
        migrations.AddField(
            model_name="notification",
            name="notif_type",
            field=models.CharField(
                db_index=True,
                default="",
                help_text="type of this notification as reported by ESI",
                max_length=100,
                verbose_name="type",
            ),
        ),
        migrations.AddField(
            model_name="webhook",
            name="disabled_notification_types",
            field=multiselectfield.db.fields.MultiSelectField(
                blank=True,
                choices=[
                    ("CharAppAcceptMsg", "CharAppAcceptMsg"),
                    ("CharLeftCorpMsg", "CharLeftCorpMsg"),
                    ("MoonminingAutomaticFracture", "MoonminingAutomaticFracture"),
                    ("MoonminingExtractionCancelled", "MoonminingExtractionCancelled"),
                    ("MoonminingExtractionFinished", "MoonminingExtractionFinished"),
                    ("MoonminingExtractionStarted", "MoonminingExtractionStarted"),
                    ("MoonminingLaserFired", "MoonminingLaserFired"),
                    ("StructureAnchoring", "StructureAnchoring"),
                    ("StructureDestroyed", "StructureDestroyed"),
                    ("StructureFuelAlert", "StructureFuelAlert"),
                    ("StructureLostArmor", "StructureLostArmor"),
                    ("StructureLostShields", "StructureLostShields"),
                    ("StructureOnline", "StructureOnline"),
                    ("StructureServicesOffline", "StructureServicesOffline"),
                    ("StructureUnanchoring", "StructureUnanchoring"),
                    ("StructureUnderAttack", "StructureUnderAttack"),
                    ("StructureWentHighPower", "StructureWentHighPower"),
                    ("StructureWentLowPower", "StructureWentLowPower"),
                    ("OwnershipTransferred", "OwnershipTransferred"),
                    ("OrbitalAttacked", "OrbitalAttacked"),
                    ("OrbitalReinforced", "OrbitalReinforced"),
                    ("TowerAlertMsg", "TowerAlertMsg"),
                    ("TowerResourceAlertMsg", "TowerResourceAlertMsg"),
                    ("EntosisCaptureStarted", "EntosisCaptureStarted"),
                    ("SovCommandNodeEventStarted", "SovCommandNodeEventStarted"),
                    ("SovAllClaimAquiredMsg", "SovAllClaimAquiredMsg"),
                    ("SovStructureReinforced", "SovStructureReinforced"),
                    ("SovStructureDestroyed", "SovStructureDestroyed"),
                    ("AllyJoinedWarAggressorMsg", "AllyJoinedWarAggressorMsg"),
                    ("CorpWarSurrenderMsg", "CorpWarSurrenderMsg"),
                    ("WarAdopted", "WarAdopted"),
                    ("WarDeclared", "WarDeclared"),
                    ("WarInherited", "WarInherited"),
                    ("WarRetractedByConcord", "WarRetractedByConcord"),
                ],
                default=None,
                help_text="Disables sending of notifications for selected notification types (regardless of selected notification groups)",
                max_length=704,
            ),
        ),
        migrations.AddField(
            model_name="webhook",
            name="notification_groups",
            field=multiselectfield.db.fields.MultiSelectField(
                choices=[
                    ("CM", "Corporation Member"),
                    ("MM", "Moon Mining"),
                    ("US", "Upwell Structure"),
                    ("CO", "Customs Office"),
                    ("SB", "Starbase"),
                    ("SV", "Sovereignty"),
                    ("WR", "War"),
                ],
                default=None,
                help_text="only notifications from selected groups are sent to this webhook",
                max_length=20,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="created",
            field=models.DateTimeField(
                default=None,
                help_text="Date when this notification was first received from ESI",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_read",
            field=models.BooleanField(
                default=None,
                help_text="True when this notification has read in the eve client",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_sent",
            field=models.BooleanField(
                default=False,
                help_text="True when this notification has been forwarded to Discord",
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="is_timer_added",
            field=models.BooleanField(
                default=None,
                help_text="True when a timer has been added for this notification",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="notification",
            name="notification_id",
            field=models.PositiveBigIntegerField(verbose_name="id"),
        ),
    ]
